/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.dmr.message.data.DataMessage;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.type.DataType;
import java.util.function.Function;

public class DataMessageFilter
extends Filter<IMessage, DataType> {
    private KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public DataMessageFilter() {
        super("Data Messages");
        for (DataType dataType : DataType.values()) {
            this.add(new FilterElement<DataType>(dataType));
        }
    }

    @Override
    public Function<IMessage, DataType> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof DataMessage && !(message instanceof CSBKMessage) && super.canProcess(message);
    }

    private class KeyExtractor
    implements Function<IMessage, DataType> {
        private KeyExtractor(DataMessageFilter dataMessageFilter) {
        }

        @Override
        public DataType apply(IMessage message) {
            if (message instanceof DataMessage) {
                DataMessage dataMessage = (DataMessage)message;
                return dataMessage.getSlotType().getDataType();
            }
            return null;
        }
    }
}

