/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.Opcode;
import java.util.Collection;
import java.util.function.Function;

public class ControlMessageFilter
extends Filter<IMessage, Opcode> {
    private KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public ControlMessageFilter(String name, Collection<Opcode> opcodes) {
        super(name);
        for (Opcode opcode : opcodes) {
            this.add(new FilterElement<Opcode>(opcode));
        }
    }

    @Override
    public Function<IMessage, Opcode> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    private class KeyExtractor
    implements Function<IMessage, Opcode> {
        private KeyExtractor(ControlMessageFilter controlMessageFilter) {
        }

        @Override
        public Opcode apply(IMessage message) {
            if (message instanceof CSBKMessage) {
                CSBKMessage csbk = (CSBKMessage)message;
                return csbk.getOpcode();
            }
            return null;
        }
    }
}

