/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.packet;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.message.DMRMessage;
import io.github.dsheirer.module.decode.dmr.message.data.packet.PacketSequence;
import io.github.dsheirer.module.decode.ip.IPacket;
import java.util.ArrayList;
import java.util.List;

public class DMRPacketMessage
extends DMRMessage {
    private PacketSequence mPacketSequence;
    private IPacket mPacket;
    private List<Identifier> mIdentifiers;

    public DMRPacketMessage(PacketSequence packetSequence, IPacket packet, CorrectedBinaryMessage rawPacket, int timeslot, long timestamp) {
        super(rawPacket, timestamp, timeslot);
        this.mPacketSequence = packetSequence;
        this.mPacket = packet;
    }

    public PacketSequence getPacketSequence() {
        return this.mPacketSequence;
    }

    public IPacket getPacket() {
        return this.mPacket;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CC:").append(this.getPacketSequence().getPacketSequenceHeader().getSlotType().getColorCode());
        sb.append(" FM:").append(this.getPacketSequence().getPacketSequenceHeader().getSourceLLID());
        sb.append(" TO:").append(this.getPacketSequence().getPacketSequenceHeader().getDestinationLLID());
        if (this.getPacketSequence().isEncrypted()) {
            sb.append(" ENCRYPTED");
        }
        sb.append(" ").append(this.getPacket().toString());
        return sb.toString();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.getPacketSequence().hasPacketSequenceHeader()) {
                this.mIdentifiers.addAll(this.getPacketSequence().getPacketSequenceHeader().getIdentifiers());
            }
            this.mIdentifiers.addAll(this.getPacket().getIdentifiers());
        }
        return this.mIdentifiers;
    }
}

