/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.mbc;

import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessageFactory;
import io.github.dsheirer.module.decode.dmr.message.data.header.MBCHeader;
import io.github.dsheirer.module.decode.dmr.message.data.mbc.MBCContinuationBlock;
import java.util.ArrayList;
import java.util.List;

public class MBCAssembler {
    private MBCHeader mTS1Header;
    private MBCHeader mTS2Header;
    private List<MBCContinuationBlock> mTS1ContinuationBlocks = new ArrayList<MBCContinuationBlock>();
    private List<MBCContinuationBlock> mTS2ContinuationBlocks = new ArrayList<MBCContinuationBlock>();

    public void process(MBCHeader header) {
        if (header != null && header.isValid()) {
            this.reset(header.getTimeslot());
            if (header.getTimeslot() == 1) {
                this.mTS1Header = header;
            } else if (header.getTimeslot() == 2) {
                this.mTS2Header = header;
            }
        }
    }

    public CSBKMessage process(MBCContinuationBlock continuationBlock) {
        if (continuationBlock != null) {
            if (continuationBlock.getTimeslot() == 1) {
                this.mTS1ContinuationBlocks.add(continuationBlock);
                if (continuationBlock.isLastBlock()) {
                    if (this.mTS1Header != null) {
                        CSBKMessage csbk = CSBKMessageFactory.create(this.mTS1Header, new ArrayList<MBCContinuationBlock>(this.mTS1ContinuationBlocks));
                        this.reset(1);
                        return csbk;
                    }
                    this.reset(1);
                }
            } else if (continuationBlock.getTimeslot() == 2) {
                this.mTS2ContinuationBlocks.add(continuationBlock);
                if (continuationBlock.isLastBlock()) {
                    if (this.mTS2Header != null) {
                        CSBKMessage csbk = CSBKMessageFactory.create(this.mTS2Header, new ArrayList<MBCContinuationBlock>(this.mTS2ContinuationBlocks));
                        this.reset(2);
                        return csbk;
                    }
                    this.reset(2);
                }
            }
        }
        return null;
    }

    public void reset(int timeslot) {
        if (timeslot == 1) {
            this.mTS1Header = null;
            this.mTS1ContinuationBlocks.clear();
        } else if (timeslot == 2) {
            this.mTS2Header = null;
            this.mTS2ContinuationBlocks.clear();
        }
    }
}

