/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.shorty;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCMessage;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCOpcode;
import io.github.dsheirer.module.decode.dmr.message.type.Vendor;

public abstract class ShortLCMessage
extends LCMessage
implements IMessage {
    protected static final int VENDOR_FLAG = 0;
    protected static final int[] OPCODE = new int[]{0, 1, 2, 3};
    protected static final int[] VENDOR = new int[]{4, 5, 6, 7, 8, 9, 10, 11};

    public ShortLCMessage(CorrectedBinaryMessage message, long timestamp, int timeslot) {
        super(message, timestamp, timeslot);
    }

    @Override
    public LCOpcode getOpcode() {
        return ShortLCMessage.getOpcode(this.getMessage());
    }

    protected int getOpcodeValue() {
        return this.getMessage().getInt(OPCODE);
    }

    @Override
    public Vendor getVendor() {
        return ShortLCMessage.getVendor(this.getMessage());
    }

    public static LCOpcode getOpcode(BinaryMessage binaryMessage) {
        Vendor vendor = ShortLCMessage.getVendor(binaryMessage);
        return LCOpcode.fromValue(false, binaryMessage.getInt(OPCODE), vendor);
    }

    public static Vendor getVendor(BinaryMessage binaryMessage) {
        Vendor vendor = null;
        if (binaryMessage.get(0)) {
            vendor = Vendor.fromValue(binaryMessage.getInt(VENDOR));
        }
        if (vendor == null || vendor == Vendor.UNKNOWN) {
            vendor = Vendor.STANDARD;
        }
        return vendor;
    }
}

