/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.shorty;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.BitSetFullException;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.Hamming17;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCMessageFactory;
import io.github.dsheirer.module.decode.dmr.message.data.lc.shorty.ShortLCMessage;
import io.github.dsheirer.module.decode.dmr.message.type.LCSS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLCAssembler {
    private static final Logger mLog = LoggerFactory.getLogger(SLCAssembler.class);
    private CorrectedBinaryMessage mAssemblingMessage;
    private int mFragmentCount = 0;
    private long mTimestamp;

    public ShortLCMessage process(LCSS lcss, BinaryMessage fragment, long timestamp) {
        this.mTimestamp = timestamp;
        ShortLCMessage message = null;
        switch (lcss) {
            case FIRST_FRAGMENT: {
                message = this.dispatch();
                this.mAssemblingMessage = new CorrectedBinaryMessage(68);
                this.add(fragment);
                break;
            }
            case CONTINUATION_FRAGMENT: {
                if (this.mAssemblingMessage == null) {
                    this.mAssemblingMessage = new CorrectedBinaryMessage(68);
                    this.mAssemblingMessage.setPointer(17);
                }
                this.add(fragment);
                break;
            }
            case LAST_FRAGMENT: {
                if (this.mAssemblingMessage == null) {
                    this.mAssemblingMessage = new CorrectedBinaryMessage(68);
                    this.mAssemblingMessage.setPointer(51);
                }
                this.add(fragment);
                message = this.dispatch();
                break;
            }
            default: {
                message = this.createSingleFragment(fragment);
            }
        }
        return message;
    }

    private ShortLCMessage createSingleFragment(BinaryMessage binaryMessage) {
        CorrectedBinaryMessage corrected = new CorrectedBinaryMessage(17);
        for (int x = 0; x < 17; ++x) {
            if (!binaryMessage.get(x)) continue;
            corrected.set(x);
        }
        return LCMessageFactory.createShort(corrected, this.mTimestamp, 0);
    }

    private ShortLCMessage dispatch() {
        ShortLCMessage message = null;
        if (this.mFragmentCount == 4) {
            message = SLCAssembler.decode(this.mAssemblingMessage, this.mTimestamp);
        }
        this.mAssemblingMessage = null;
        this.mFragmentCount = 0;
        return message;
    }

    private static ShortLCMessage decode(BinaryMessage interleaved, long timestamp) {
        if (interleaved != null) {
            boolean valid = true;
            CorrectedBinaryMessage deinterleaved = new CorrectedBinaryMessage(68);
            for (int index = 0; index < 67; ++index) {
                if (!interleaved.get(index)) continue;
                deinterleaved.set(index * 17 % 67);
            }
            if (interleaved.get(67)) {
                deinterleaved.set(67);
            }
            int errorCount = 0;
            for (int row = 0; row < 4; ++row) {
                int rowErrorCount = Hamming17.checkAndCorrect(deinterleaved, row * 17);
                errorCount += rowErrorCount;
                if (rowErrorCount <= 1) continue;
                valid = false;
            }
            if (valid) {
                for (int column = 0; column < 17; ++column) {
                    boolean parity = deinterleaved.get(column);
                    for (int y = 1; y < 4; ++y) {
                        parity ^= deinterleaved.get(column + y * 17);
                    }
                    if (!parity) continue;
                    valid = false;
                }
            }
            CorrectedBinaryMessage extractedMessage = new CorrectedBinaryMessage(51);
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 12; ++column) {
                    extractedMessage.set(row * 12 + column, deinterleaved.get(row * 17 + column));
                }
            }
            extractedMessage.setCorrectedBitCount(errorCount);
            extractedMessage.setSize(36);
            ShortLCMessage slco = LCMessageFactory.createShort(extractedMessage, timestamp, 0);
            slco.setValid(valid);
            return slco;
        }
        return null;
    }

    private void add(BinaryMessage payload) {
        if (payload == null || payload.size() != 17) {
            return;
        }
        ++this.mFragmentCount;
        try {
            if (this.mAssemblingMessage == null) {
                this.mAssemblingMessage = new CorrectedBinaryMessage(68);
            }
            for (int x = 0; x < 17; ++x) {
                this.mAssemblingMessage.add(payload.get(x));
            }
        }
        catch (BitSetFullException bsfe) {
            this.dispatch();
        }
    }

    public static void main(String[] args) {
        String raw = "A0000C0000A0000C0000";
        System.out.println(" RAW:" + raw);
        String bits = "10100000000000000110000000000000001010000000000000011000000000000000";
        BinaryMessage rawBin = BinaryMessage.load(bits);
        System.out.println("ORIG:" + rawBin.toHexString());
        ShortLCMessage slc = SLCAssembler.decode(rawBin, System.currentTimeMillis());
        System.out.println(slc.toString());
    }
}

