/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.shorty;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.message.data.lc.shorty.ShortLCMessage;
import java.util.Collections;
import java.util.List;

public class HyteraXPTChannel
extends ShortLCMessage {
    private static final int[] FREE_REPEATER = new int[]{12, 13, 14, 15};
    private static final int[] PRIORITY_CALL_REPEATER = new int[]{16, 17, 18, 19};
    private static final int[] PRIORITY_CALL_HASHED_ADDRESS = new int[]{20, 21, 22, 23, 24, 25, 26, 27};

    public HyteraXPTChannel(CorrectedBinaryMessage message, long timestamp, int timeslot) {
        super(message, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC ERROR] ");
        }
        sb.append("SLC HYTERA XPT");
        if (this.isAllChannelsBusy()) {
            sb.append(" ALL REPEATERS BUSY");
        } else {
            sb.append(" FREE REPEATER:").append(this.getFreeRepeater());
        }
        if (this.hasPriorityCall()) {
            sb.append(" PRIORITY CALL FOR:").append(this.getPriorityCallHashedAddress());
            sb.append(" ON REPEATER:").append(this.getPriorityCallRepeater());
        }
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public boolean isAllChannelsBusy() {
        return this.getFreeRepeater() == 0;
    }

    public int getFreeRepeater() {
        return this.getMessage().getInt(FREE_REPEATER);
    }

    public boolean hasPriorityCall() {
        return this.getPriorityCallRepeater() > 0;
    }

    public int getPriorityCallRepeater() {
        return this.getMessage().getInt(PRIORITY_CALL_REPEATER);
    }

    public String getPriorityCallHashedAddress() {
        return String.format("%02X", this.getMessage().getInt(PRIORITY_CALL_HASHED_ADDRESS));
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.emptyList();
    }
}

