/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.shorty;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.message.data.lc.shorty.ShortLCMessage;
import io.github.dsheirer.module.decode.dmr.message.type.SystemIdentityCode;
import java.util.ArrayList;
import java.util.List;

public class ControlChannelSystemParameters
extends ShortLCMessage {
    private static final int SYSTEM_IDENTITY_CODE_OFFSET = 4;
    private static final int REGISTRATION_REQUIRED_FLAG = 18;
    private static final int[] COMMON_SLOT_COUNTER = new int[]{19, 20, 21, 22, 23, 24, 25, 26, 27};
    private SystemIdentityCode mSystemIdentityCode;
    private List<Identifier> mIdentifiers;

    public ControlChannelSystemParameters(CorrectedBinaryMessage message, long timestamp, int timeslot) {
        super(message, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC ERROR] ");
        }
        sb.append("SLC TIER III CONTROL CHANNEL ").append((Object)this.getSystemIdentityCode().getModel());
        sb.append(" NET:").append(this.getSystemIdentityCode().getNetwork());
        sb.append(" SITE:").append(this.getSystemIdentityCode().getSite());
        if (this.isRegistrationRequired()) {
            sb.append(" REGISTRATION REQUIRED");
        }
        sb.append(" SLOT COUNTER:").append(this.getCommonSlotCounter());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public SystemIdentityCode getSystemIdentityCode() {
        if (this.mSystemIdentityCode == null) {
            this.mSystemIdentityCode = new SystemIdentityCode(this.getMessage(), 4, false);
        }
        return this.mSystemIdentityCode;
    }

    public boolean isRegistrationRequired() {
        return this.getMessage().get(18);
    }

    public int getCommonSlotCounter() {
        return this.getMessage().getInt(COMMON_SLOT_COUNTER);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getSystemIdentityCode().getNetwork());
            this.mIdentifiers.add(this.getSystemIdentityCode().getSite());
        }
        return this.mIdentifiers;
    }
}

