/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.shorty;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.channel.DmrRestLsn;
import io.github.dsheirer.module.decode.dmr.channel.ITimeslotFrequencyReceiver;
import io.github.dsheirer.module.decode.dmr.channel.TimeslotFrequency;
import io.github.dsheirer.module.decode.dmr.identifier.DMRSite;
import io.github.dsheirer.module.decode.dmr.message.data.lc.shorty.ShortLCMessage;
import java.util.ArrayList;
import java.util.List;

public class CapacityPlusRestChannel
extends ShortLCMessage
implements ITimeslotFrequencyReceiver {
    private static final int[] UNKNOWN = new int[]{12, 13, 14};
    private static final int[] REST_LSN = new int[]{15, 16, 17, 18, 19};
    private static final int[] SITE = new int[]{20, 21, 22, 23, 24};
    private static final int[] UNKNOWN_2 = new int[]{25, 26, 27};
    private DmrRestLsn mRestChannel;
    private DMRSite mSite;
    private List<Identifier> mIdentifiers;

    public CapacityPlusRestChannel(CorrectedBinaryMessage message, long timestamp, int timeslot) {
        super(message, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC ERROR] ");
        }
        sb.append("SLC MOTOROLA CAP+ SITE:").append(this.getSite());
        sb.append(" ").append(this.getRestChannel());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public DMRSite getSite() {
        if (this.mSite == null) {
            this.mSite = DMRSite.create(this.getMessage().getInt(SITE));
        }
        return this.mSite;
    }

    public DmrRestLsn getRestChannel() {
        if (this.mRestChannel == null) {
            this.mRestChannel = new DmrRestLsn(this.getRestLSN());
        }
        return this.mRestChannel;
    }

    public int getRestLSN() {
        return this.getMessage().getInt(REST_LSN);
    }

    @Override
    public int[] getLogicalChannelNumbers() {
        return this.getRestChannel().getLogicalChannelNumbers();
    }

    @Override
    public void apply(List<TimeslotFrequency> timeslotFrequencies) {
        this.getRestChannel().apply(timeslotFrequencies);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getSite());
            this.mIdentifiers.add(this.getRestChannel());
        }
        return this.mIdentifiers;
    }
}

