/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.full.hytera;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.identifier.DMRRadio;
import io.github.dsheirer.module.decode.dmr.message.IServiceOptionsProvider;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.FullLCMessage;
import io.github.dsheirer.module.decode.dmr.message.type.ServiceOptions;

public abstract class HyteraFullLC
extends FullLCMessage
implements IServiceOptionsProvider {
    private static final int[] SERVICE_OPTIONS = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] FREE_REPEATER = new int[]{24, 25, 26, 27};
    private static final int[] PRIORITY_REPEATER = new int[]{28, 29, 30, 31};
    protected static final int[] TARGET_ADDRESS = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] PRIORITY_CALL_HASHED_ADDRESS = new int[]{48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] SOURCE_ADDRESS = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private ServiceOptions mServiceOptions;
    protected RadioIdentifier mSourceRadio;

    public HyteraFullLC(CorrectedBinaryMessage message, long timestamp, int timeslot) {
        super(message, timestamp, timeslot);
    }

    @Override
    public ServiceOptions getServiceOptions() {
        if (this.mServiceOptions == null) {
            this.mServiceOptions = new ServiceOptions(this.getMessage().getInt(SERVICE_OPTIONS));
        }
        return this.mServiceOptions;
    }

    public boolean isAllChannelsBusy() {
        return this.getFreeRepeater() == 0;
    }

    public int getFreeRepeater() {
        return this.getMessage().getInt(FREE_REPEATER);
    }

    public boolean hasPriorityCall() {
        return this.getPriorityCallRepeater() > 0;
    }

    public int getPriorityCallRepeater() {
        return this.getMessage().getInt(PRIORITY_REPEATER);
    }

    public String getPriorityCallHashedAddress() {
        return String.format("%02X", this.getMessage().getInt(PRIORITY_CALL_HASHED_ADDRESS)).toUpperCase();
    }

    public RadioIdentifier getSourceRadio() {
        if (this.mSourceRadio == null) {
            this.mSourceRadio = DMRRadio.createFrom(this.getMessage().getInt(SOURCE_ADDRESS));
        }
        return this.mSourceRadio;
    }
}

