/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.full;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCOpcode;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.FullLCMessage;
import io.github.dsheirer.module.decode.dmr.message.type.Vendor;
import java.util.Collections;
import java.util.List;

public class UnknownFullLCMessage
extends FullLCMessage {
    public UnknownFullLCMessage(CorrectedBinaryMessage message, long timestamp, int timeslot) {
        super(message, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("FLC UNKNOWN");
        LCOpcode opcode = this.getOpcode();
        if (opcode != LCOpcode.FULL_STANDARD_UNKNOWN) {
            sb.append(" ").append((Object)opcode);
        } else {
            sb.append(" OPCODE:").append(this.getOpcodeValue());
        }
        Vendor vendor = this.getVendor();
        if (vendor != Vendor.STANDARD) {
            if (vendor == Vendor.UNKNOWN) {
                sb.append(" VENDOR:").append(this.getVendorValue());
            } else {
                sb.append(" VENDOR:").append((Object)vendor);
            }
        }
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.emptyList();
    }
}

