/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.full;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.integer.IntegerIdentifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.identifier.DMRRadio;
import io.github.dsheirer.module.decode.dmr.identifier.DMRTalkgroup;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.FullLCMessage;
import java.util.ArrayList;
import java.util.List;

public class TerminatorData
extends FullLCMessage {
    private static final int[] DESTINATION_LLID = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] SOURCE_LLID = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int GROUP_INDIVIDUAL_FLAG = 64;
    private static final int RESPONSE_REQUESTED = 65;
    private static final int FULL_MESSAGE_FLAG = 66;
    private static final int RESYNC_FLAG = 68;
    private static final int[] SEND_SEQUENCE_NUMBER = new int[]{69, 70, 71};
    private RadioIdentifier mSourceLLID;
    private IntegerIdentifier mDestinationLLID;
    private List<Identifier> mIdentifiers;

    public TerminatorData(CorrectedBinaryMessage message, long timestamp, int timeslot) {
        super(message, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC ERROR " + this.getMessage().getCorrectedBitCount() + "] ");
        }
        sb.append("FM:").append(this.getSourceLLID());
        sb.append(" TO:").append(this.getDestinationLLID());
        sb.append(this.isFullMessage() ? " COMPLETE" : " FRAGMENT");
        sb.append(" SEQUENCE:").append(this.getSendSequenceNumber());
        if (this.isResync()) {
            sb.append(" RESYNC");
        }
        if (this.isResponseRequested()) {
            sb.append(" ACK:YES");
        }
        return sb.toString();
    }

    public IntegerIdentifier getDestinationLLID() {
        if (this.mDestinationLLID == null) {
            this.mDestinationLLID = this.isGroupDestination() ? DMRTalkgroup.create(this.getMessage().getInt(DESTINATION_LLID)) : DMRRadio.createTo(this.getMessage().getInt(DESTINATION_LLID));
        }
        return this.mDestinationLLID;
    }

    public boolean isGroupDestination() {
        return this.getMessage().get(64);
    }

    public RadioIdentifier getSourceLLID() {
        if (this.mSourceLLID == null) {
            this.mSourceLLID = DMRRadio.createFrom(this.getMessage().getInt(SOURCE_LLID));
        }
        return this.mSourceLLID;
    }

    public boolean isResponseRequested() {
        return this.getMessage().get(65);
    }

    public boolean isFullMessage() {
        return this.getMessage().get(66);
    }

    public boolean isResync() {
        return this.getMessage().get(68);
    }

    public int getSendSequenceNumber() {
        return this.getMessage().getInt(SEND_SEQUENCE_NUMBER);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getSourceLLID());
            this.mIdentifiers.add(this.getDestinationLLID());
        }
        return this.mIdentifiers;
    }
}

