/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.full;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.FullLCMessage;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.TalkerAliasBlock1;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.TalkerAliasBlock2;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.TalkerAliasBlock3;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.TalkerAliasComplete;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.TalkerAliasHeader;

public class TalkerAliasAssembler {
    private TalkerAliasHeader mHeaderTs1;
    private TalkerAliasBlock1 mBlock1Ts1;
    private TalkerAliasBlock2 mBlock2Ts1;
    private TalkerAliasBlock3 mBlock3Ts1;
    private TalkerAliasHeader mHeaderTs2;
    private TalkerAliasBlock1 mBlock1Ts2;
    private TalkerAliasBlock2 mBlock2Ts2;
    private TalkerAliasBlock3 mBlock3Ts2;
    private boolean mEmptyTs1 = true;
    private boolean mEmptyTs2 = true;

    public void reset(int timeslot) {
        if (timeslot == 1 && !this.mEmptyTs1) {
            this.mHeaderTs1 = null;
            this.mBlock1Ts1 = null;
            this.mBlock2Ts1 = null;
            this.mBlock3Ts1 = null;
            this.mEmptyTs1 = true;
        } else if (timeslot == 2 && !this.mEmptyTs2) {
            this.mHeaderTs2 = null;
            this.mBlock1Ts2 = null;
            this.mBlock2Ts2 = null;
            this.mBlock3Ts2 = null;
            this.mEmptyTs2 = true;
        }
    }

    public TalkerAliasComplete process(FullLCMessage message) {
        switch (message.getOpcode()) {
            case FULL_STANDARD_TALKER_ALIAS_HEADER: {
                if (message instanceof TalkerAliasHeader) {
                    TalkerAliasHeader tah = (TalkerAliasHeader)message;
                    if (message.getTimeslot() == 1) {
                        this.mHeaderTs1 = tah;
                        this.mEmptyTs1 = false;
                        return this.assemble(1);
                    }
                    this.mHeaderTs2 = tah;
                    this.mEmptyTs2 = false;
                    return this.assemble(2);
                }
            }
            case FULL_STANDARD_TALKER_ALIAS_BLOCK_1: {
                if (message instanceof TalkerAliasBlock1) {
                    TalkerAliasBlock1 tab1 = (TalkerAliasBlock1)message;
                    if (message.getTimeslot() == 1) {
                        this.mBlock1Ts1 = tab1;
                        this.mEmptyTs1 = false;
                        return this.assemble(1);
                    }
                    this.mBlock1Ts2 = tab1;
                    this.mEmptyTs2 = false;
                    return this.assemble(2);
                }
            }
            case FULL_STANDARD_TALKER_ALIAS_BLOCK_2: {
                if (message instanceof TalkerAliasBlock2) {
                    TalkerAliasBlock2 tab2 = (TalkerAliasBlock2)message;
                    if (message.getTimeslot() == 1) {
                        this.mBlock2Ts1 = tab2;
                        this.mEmptyTs1 = false;
                        return this.assemble(1);
                    }
                    this.mBlock2Ts2 = tab2;
                    this.mEmptyTs2 = false;
                    return this.assemble(2);
                }
            }
            case FULL_STANDARD_TALKER_ALIAS_BLOCK_3: {
                if (!(message instanceof TalkerAliasBlock3)) break;
                TalkerAliasBlock3 tab3 = (TalkerAliasBlock3)message;
                if (message.getTimeslot() == 1) {
                    this.mBlock3Ts1 = tab3;
                    this.mEmptyTs1 = false;
                    return this.assemble(1);
                }
                this.mBlock3Ts2 = tab3;
                this.mEmptyTs2 = false;
                return this.assemble(2);
            }
        }
        return null;
    }

    private TalkerAliasComplete assemble(int timeslot) {
        if (timeslot == 1) {
            return this.assemble(this.mHeaderTs1, this.mBlock1Ts1, this.mBlock2Ts1, this.mBlock3Ts1);
        }
        return this.assemble(this.mHeaderTs2, this.mBlock1Ts2, this.mBlock2Ts2, this.mBlock3Ts2);
    }

    private TalkerAliasComplete assemble(TalkerAliasHeader header, TalkerAliasBlock1 block1, TalkerAliasBlock2 block2, TalkerAliasBlock3 block3) {
        if (header != null) {
            int bitLength = header.getTotalBitLength();
            if (1 <= bitLength && bitLength <= 49) {
                return new TalkerAliasComplete(header.getPayloadFragment(), header.getFormat(), header.getCharacterLength(), header.getTimestamp(), header.getTimeslot());
            }
            if (50 <= bitLength && bitLength <= 105 && block1 != null) {
                CorrectedBinaryMessage message = new CorrectedBinaryMessage(105);
                message.load(0, header.getPayloadFragment());
                message.load(49, block1.getPayloadFragment());
                return new TalkerAliasComplete(message, header.getFormat(), header.getCharacterLength(), header.getTimestamp(), header.getTimeslot());
            }
            if (106 <= bitLength && bitLength <= 161 && block1 != null && block2 != null) {
                CorrectedBinaryMessage message = new CorrectedBinaryMessage(161);
                message.load(0, header.getPayloadFragment());
                message.load(49, block1.getPayloadFragment());
                message.load(105, block2.getPayloadFragment());
                return new TalkerAliasComplete(message, header.getFormat(), header.getCharacterLength(), header.getTimestamp(), header.getTimeslot());
            }
            if (162 <= bitLength && bitLength <= 217 && block1 != null && block2 != null && block3 != null) {
                CorrectedBinaryMessage message = new CorrectedBinaryMessage(217);
                message.load(0, header.getPayloadFragment());
                message.load(49, block1.getPayloadFragment());
                message.load(105, block2.getPayloadFragment());
                message.load(161, block3.getPayloadFragment());
                return new TalkerAliasComplete(message, header.getFormat(), header.getCharacterLength(), header.getTimestamp(), header.getTimeslot());
            }
        }
        return null;
    }
}

