/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.full;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.location.LocationIdentifier;
import io.github.dsheirer.module.decode.dmr.identifier.DMRLocation;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.FullLCMessage;
import io.github.dsheirer.module.decode.dmr.message.type.PositionError;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public class GPSInformation
extends FullLCMessage {
    private static final double LATITUDE_UNITS = 180.0 / FastMath.pow((double)2.0, (double)24.0);
    private static final double LONGITUDE_UNITS = 360.0 / FastMath.pow((double)2.0, (double)25.0);
    private static final int[] POSITION_ERROR = new int[]{20, 21, 22};
    private static final int LONGITUDE_START = 23;
    private static final int LONGITUDE_END = 47;
    private static final int LATITUDE_START = 48;
    private static final int LATITUDE_END = 71;
    private DMRLocation mGPSLocation;
    private List<Identifier> mIdentifiers;

    public GPSInformation(CorrectedBinaryMessage message, long timestamp, int timeslot) {
        super(message, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("GPS LOCATION ");
        sb.append(this.getGPSLocation().toString());
        sb.append(" POSITION ERROR:").append(this.getPositionError().toString());
        return sb.toString();
    }

    public PositionError getPositionError() {
        return PositionError.fromValue(this.getMessage().getInt(POSITION_ERROR));
    }

    public double getLatitude() {
        return (double)this.getMessage().getTwosComplement(48, 71) * LATITUDE_UNITS;
    }

    public double getLongitude() {
        return (double)this.getMessage().getTwosComplement(23, 47) * LONGITUDE_UNITS;
    }

    public GeoPosition getPosition() {
        return new GeoPosition(this.getLatitude(), this.getLongitude());
    }

    public LocationIdentifier getGPSLocation() {
        if (this.mGPSLocation == null) {
            this.mGPSLocation = DMRLocation.createFrom(this.getLatitude(), this.getLongitude());
        }
        return this.mGPSLocation;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getGPSLocation());
        }
        return this.mIdentifiers;
    }
}

