/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.full;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.BitSetFullException;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.Hamming16;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCMessageFactory;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.FullLCMessage;
import io.github.dsheirer.module.decode.dmr.message.type.LCSS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLCAssembler {
    private static final Logger mLog = LoggerFactory.getLogger(FLCAssembler.class);
    private CorrectedBinaryMessage mAssemblingMessage;
    private int mFragmentCount = 0;
    private long mTimestamp;
    private int mTimeslot;

    public FLCAssembler(int timeslot) {
        this.mTimeslot = timeslot;
    }

    public FullLCMessage process(LCSS lcss, BinaryMessage fragment, long timestamp) {
        this.mTimestamp = timestamp;
        FullLCMessage message = null;
        switch (lcss) {
            case FIRST_FRAGMENT: {
                message = this.dispatch();
                this.mAssemblingMessage = new CorrectedBinaryMessage(128);
                this.add(fragment);
                break;
            }
            case CONTINUATION_FRAGMENT: {
                if (this.mAssemblingMessage == null) {
                    this.mAssemblingMessage = new CorrectedBinaryMessage(128);
                    this.mAssemblingMessage.setPointer(32);
                }
                this.add(fragment);
                break;
            }
            case LAST_FRAGMENT: {
                if (this.mAssemblingMessage == null) {
                    this.mAssemblingMessage = new CorrectedBinaryMessage(128);
                    this.mAssemblingMessage.setPointer(96);
                }
                this.add(fragment);
                message = this.dispatch();
                break;
            }
            case SINGLE_FRAGMENT: {
                this.dispatch();
            }
        }
        return message;
    }

    private FullLCMessage dispatch() {
        FullLCMessage message = null;
        if (this.mFragmentCount == 4) {
            message = FLCAssembler.decode(this.mAssemblingMessage, this.mTimestamp, this.mTimeslot);
        }
        this.mAssemblingMessage = null;
        this.mFragmentCount = 0;
        return message;
    }

    private static FullLCMessage decode(BinaryMessage message, long timestamp, int timeslot) {
        if (message != null) {
            int column;
            int row;
            boolean valid = true;
            CorrectedBinaryMessage descrambled = new CorrectedBinaryMessage(128);
            descrambled.set(127, message.get(127));
            for (int i = 0; i < 127; ++i) {
                int src = i * 8 % 127;
                boolean x = message.get(src);
                descrambled.set(i, message.get(src));
            }
            int errorCount = 0;
            for (int row2 = 0; row2 < 8; ++row2) {
                int rowErrorCount = Hamming16.checkAndCorrect(descrambled, row2 * 16);
                if ((errorCount += rowErrorCount) <= 1) continue;
                valid = false;
            }
            if (valid) {
                for (int column2 = 0; column2 < 16; ++column2) {
                    boolean parity = descrambled.get(column2);
                    for (int y = 1; y < 8; ++y) {
                        parity ^= descrambled.get(column2 + y * 16);
                    }
                    if (!parity) continue;
                    valid = false;
                }
            }
            CorrectedBinaryMessage extractedMessage = new CorrectedBinaryMessage(77);
            int pointer = 0;
            for (row = 0; row < 2; ++row) {
                for (column = 0; column < 11; ++column) {
                    extractedMessage.set(pointer++, descrambled.get(row * 16 + column));
                }
            }
            for (row = 2; row < 7; ++row) {
                for (column = 0; column < 10; ++column) {
                    extractedMessage.set(pointer++, descrambled.get(row * 16 + column));
                }
                extractedMessage.set(70 + row, descrambled.get(row * 16 + 10));
            }
            extractedMessage.setCorrectedBitCount(errorCount);
            FullLCMessage flco = LCMessageFactory.createFull(extractedMessage, timestamp, timeslot, false);
            flco.setValid(valid);
            return flco;
        }
        return null;
    }

    private void add(BinaryMessage payload) {
        if (payload == null || payload.size() != 32) {
            return;
        }
        ++this.mFragmentCount;
        try {
            if (this.mAssemblingMessage == null) {
                this.mAssemblingMessage = new CorrectedBinaryMessage(96);
            }
            for (int x = 0; x < 32; ++x) {
                this.mAssemblingMessage.add(payload.get(x));
            }
        }
        catch (BitSetFullException bsfe) {
            this.dispatch();
        }
    }
}

