/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc.full;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRCDMR;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.identifier.DMRTalkgroup;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCOpcode;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.FullLCMessage;
import io.github.dsheirer.module.decode.dmr.message.type.EncryptionAlgorithm;
import java.util.ArrayList;
import java.util.List;

public class EncryptionParameters
extends FullLCMessage {
    private static final int[] KEY_ID = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] INITIALIZATION_VECTOR = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] DESTINATION_GROUP = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private DMRTalkgroup mTalkgroup;
    private List<Identifier> mIdentifiers;

    public EncryptionParameters(CorrectedBinaryMessage message, long timestamp, int timeslot) {
        super(message, timestamp, timeslot);
        int bitErrors = CRCDMR.correctCCITT80(message, 0, 80, 38550);
        this.setValid(bitErrors < 2);
    }

    @Override
    public LCOpcode getOpcode() {
        return LCOpcode.FULL_ENCRYPTION_PARAMETERS;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        if (this.isEncrypted()) {
            sb.append(" *ENCRYPTED*");
        }
        if (this.isReservedBitSet()) {
            sb.append(" *RESERVED-BIT*");
        }
        sb.append("FLC ENCRYPTION PARAMETERS");
        sb.append(" VENDOR:").append((Object)this.getVendor());
        if (this.getAlgorithm() == EncryptionAlgorithm.UNKNOWN) {
            sb.append(" ALGORITHM:").append(this.getOpcodeValue());
        } else {
            sb.append(" ALGORITHM:").append((Object)this.getAlgorithm());
        }
        sb.append(" KEY:").append(this.getKeyId());
        sb.append(" IV:").append(this.getInitializationVector());
        sb.append(" TALKGROUP:").append(this.getTalkgroup());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public String getDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append("ENCRYPTION ALGORITHM:").append((Object)this.getAlgorithm());
        sb.append(" KEY:").append(this.getKeyId());
        sb.append(" IV:").append(this.getInitializationVector());
        sb.append(" VENDOR:").append((Object)this.getVendor());
        return sb.toString();
    }

    public EncryptionAlgorithm getAlgorithm() {
        return EncryptionAlgorithm.fromValue(this.getOpcodeValue());
    }

    public DMRTalkgroup getTalkgroup() {
        if (this.mTalkgroup == null) {
            this.mTalkgroup = new DMRTalkgroup(this.getMessage().getInt(DESTINATION_GROUP));
        }
        return this.mTalkgroup;
    }

    public int getKeyId() {
        return this.getMessage().getInt(KEY_ID);
    }

    public String getInitializationVector() {
        return this.getMessage().getHex(INITIALIZATION_VECTOR, 8);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTalkgroup());
        }
        return this.mIdentifiers;
    }
}

