/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.lc;

import io.github.dsheirer.module.decode.dmr.message.type.Vendor;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;

public enum LCOpcode {
    FULL_STANDARD_GROUP_VOICE_CHANNEL_USER(Vendor.STANDARD, true, 0, "GROUP VOICE CHANNEL USER"),
    FULL_STANDARD_UNIT_TO_UNIT_VOICE_CHANNEL_USER(Vendor.STANDARD, true, 3, "UNIT-TO-UNIT VOICE CHANNEL USER"),
    FULL_STANDARD_TALKER_ALIAS_HEADER(Vendor.STANDARD, true, 4, "TALKER ALIAS HEADER"),
    FULL_STANDARD_TALKER_ALIAS_BLOCK_1(Vendor.STANDARD, true, 5, "TALKER ALIAS BLOCK 1"),
    FULL_STANDARD_TALKER_ALIAS_BLOCK_2(Vendor.STANDARD, true, 6, "TALKER ALIAS BLOCK 2"),
    FULL_STANDARD_TALKER_ALIAS_BLOCK_3(Vendor.STANDARD, true, 7, "TALKER ALIAS BLOCK 3"),
    FULL_STANDARD_TALKER_ALIAS_COMPLETE(Vendor.STANDARD, true, -1, "TALKER ALIAS COMPLETE"),
    FULL_STANDARD_GPS_INFO(Vendor.STANDARD, true, 8, "GPS INFO"),
    FULL_STANDARD_TERMINATOR_DATA(Vendor.STANDARD, true, 48, "TERMINATOR DATA"),
    FULL_STANDARD_UNKNOWN(Vendor.STANDARD, true, -1, "FULL UNKNOWN"),
    FULL_MOTOROLA_GROUP_VOICE_CHANNEL_USER(Vendor.MOTOROLA_CAPACITY_PLUS, true, 0, "GROUP VOICE CHANNEL USER"),
    FULL_CAPACITY_PLUS_WIDE_AREA_VOICE_CHANNEL_USER(Vendor.MOTOROLA_CAPACITY_PLUS, true, 4, "WAN GROUP VOICE CHANNEL USER"),
    FULL_CAPACITY_PLUS_ENCRYPTED_VOICE_CHANNEL_USER(Vendor.MOTOROLA_CAPACITY_PLUS, true, 32, "ENCRYPTED VOICE CHANNEL USER"),
    FULL_ENCRYPTION_PARAMETERS(Vendor.MOTOROLA_CAPACITY_PLUS, true, 33, "ENCRYPTION PARAMETERS"),
    FULL_HYTERA_GROUP_VOICE_CHANNEL_USER(Vendor.HYTERA_68, true, 0, "HYTERA GROUP VOICE CHANNEL USER"),
    FULL_HYTERA_UNIT_TO_UNIT_VOICE_CHANNEL_USER(Vendor.HYTERA_68, true, 3, "HYTERA UNIT-TO-UNIT VOICE CHANNEL USER"),
    FULL_HYTERA_TERMINATOR(Vendor.HYTERA_68, true, 48, "HYTERA TERMINATOR"),
    SHORT_STANDARD_NULL_MESSAGE(Vendor.STANDARD, false, 0, "NULL MESSAGE"),
    SHORT_STANDARD_ACTIVITY_UPDATE(Vendor.STANDARD, false, 1, "ACTIVITY UPDATE"),
    SHORT_STANDARD_CONTROL_CHANNEL_SYSTEM_PARAMETERS(Vendor.STANDARD, false, 2, "CONTROL CHANNEL SYSTEM PARAMETERS"),
    SHORT_STANDARD_TRAFFIC_CHANNEL_SYSTEM_PARAMETERS(Vendor.STANDARD, false, 3, "TRAFFIC CHANNEL SYSTEM PARAMETERS"),
    SHORT_CAPACITY_PLUS_REST_CHANNEL_NOTIFICATION(Vendor.MOTOROLA_CAPACITY_PLUS, false, 15, "REST CHANNEL NOTIFICATION"),
    SHORT_STANDARD_XPT_CHANNEL(Vendor.STANDARD, false, 8, "STANDARD XPT CHANNEL"),
    SHORT_HYTERA_XPT_CHANNEL(Vendor.HYTERA_68, false, 8, "HYTERA XPT CHANNEL"),
    SHORT_CONNECT_PLUS_TRAFFIC_CHANNEL(Vendor.STANDARD, false, 9, "TRAFFIC CHANNEL INFO"),
    SHORT_CONNECT_PLUS_CONTROL_CHANNEL(Vendor.STANDARD, false, 10, "CONTROL CHANNEL INFO"),
    SHORT_STANDARD_UNKNOWN(Vendor.STANDARD, false, -1, "UNKNOWN");

    private static final EnumSet<LCOpcode> TALKER_ALIAS_OPCODES;
    private final Vendor mVendor;
    private final boolean mFull;
    private final int mValue;
    private final String mLabel;
    private static final Map<Vendor, Map<Integer, LCOpcode>> FULL_LOOKUP_MAP;
    private static final Map<Vendor, Map<Integer, LCOpcode>> SHORT_LOOKUP_MAP;

    private LCOpcode(Vendor vendor, boolean full, int value, String label) {
        this.mVendor = vendor;
        this.mFull = full;
        this.mValue = value;
        this.mLabel = label;
    }

    public Vendor getVendor() {
        return this.mVendor;
    }

    public boolean isFull() {
        return this.mFull;
    }

    public boolean isShort() {
        return !this.mFull;
    }

    public boolean isTalkerAliasOpcode() {
        return TALKER_ALIAS_OPCODES.contains((Object)this);
    }

    public int getValue() {
        return this.mValue;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public String toString() {
        return this.getLabel();
    }

    public static LCOpcode fromValue(boolean full, int value, Vendor vendor) {
        if (full) {
            LCOpcode fullOpcode = FULL_STANDARD_UNKNOWN;
            Map<Integer, LCOpcode> map = FULL_LOOKUP_MAP.get((Object)vendor);
            if (map != null && map.containsKey(value)) {
                fullOpcode = map.get(value);
            }
            return fullOpcode;
        }
        LCOpcode shortOpcode = SHORT_STANDARD_UNKNOWN;
        Map<Integer, LCOpcode> map = SHORT_LOOKUP_MAP.get((Object)vendor);
        if (map != null && map.containsKey(value)) {
            shortOpcode = map.get(value);
        }
        return shortOpcode;
    }

    static {
        TALKER_ALIAS_OPCODES = EnumSet.of(FULL_STANDARD_TALKER_ALIAS_HEADER, FULL_STANDARD_TALKER_ALIAS_BLOCK_1, FULL_STANDARD_TALKER_ALIAS_BLOCK_2, FULL_STANDARD_TALKER_ALIAS_BLOCK_3);
        FULL_LOOKUP_MAP = new EnumMap<Vendor, Map<Integer, LCOpcode>>(Vendor.class);
        SHORT_LOOKUP_MAP = new EnumMap<Vendor, Map<Integer, LCOpcode>>(Vendor.class);
        for (LCOpcode opcode : LCOpcode.values()) {
            TreeMap<Integer, LCOpcode> map;
            if (opcode.isFull()) {
                if (FULL_LOOKUP_MAP.containsKey((Object)opcode.getVendor())) {
                    FULL_LOOKUP_MAP.get((Object)opcode.getVendor()).put(opcode.getValue(), opcode);
                    continue;
                }
                map = new TreeMap<Integer, LCOpcode>();
                map.put(opcode.getValue(), opcode);
                FULL_LOOKUP_MAP.put(opcode.getVendor(), map);
                continue;
            }
            if (SHORT_LOOKUP_MAP.containsKey((Object)opcode.getVendor())) {
                SHORT_LOOKUP_MAP.get((Object)opcode.getVendor()).put(opcode.getValue(), opcode);
                continue;
            }
            map = new TreeMap();
            map.put(opcode.getValue(), opcode);
            SHORT_LOOKUP_MAP.put(opcode.getVendor(), map);
        }
    }
}

