/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.header.motorola;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.header.ProprietaryDataHeader;
import io.github.dsheirer.module.decode.dmr.message.type.ServiceAccessPoint;
import io.github.dsheirer.module.decode.dmr.message.type.Vendor;

public class MotorolaDataEncryptionHeader
extends ProprietaryDataHeader {
    private static final int[] SERVICE_ACCESS_POINT = new int[]{0, 1, 2, 3};
    private static final int[] VENDOR = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] ALGORITHM = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] KEY_ID = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] UNKNOWN = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] INITIALIZATION_VECTOR = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};

    public MotorolaDataEncryptionHeader(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CC:").append(this.getSlotType().getColorCode());
        sb.append(" MOTOROLA DATA ENCRYPTION HEADER");
        sb.append(" SAP:").append((Object)this.getServiceAccessPoint());
        sb.append(" ALGORITHM?:").append(this.getAlgorithm());
        sb.append(" KEY:").append(this.getKeyId());
        sb.append(" IV:").append(this.getInitializationVector());
        sb.append(" UNK:").append(this.getUnknown());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public String getUnknown() {
        return this.getMessage().getHex(UNKNOWN, 4);
    }

    public int getKeyId() {
        return this.getMessage().getInt(KEY_ID);
    }

    public int getAlgorithm() {
        return this.getMessage().getInt(ALGORITHM);
    }

    public String getInitializationVector() {
        return this.getMessage().getHex(INITIALIZATION_VECTOR, 8);
    }

    public static Vendor getVendor(BinaryMessage message) {
        return Vendor.fromValue(message.getInt(VENDOR));
    }

    @Override
    public Vendor getVendor() {
        return MotorolaDataEncryptionHeader.getVendor(this.getMessage());
    }

    public static ServiceAccessPoint getServiceAccessPoint(CorrectedBinaryMessage message) {
        return ServiceAccessPoint.fromValue(message.getInt(SERVICE_ACCESS_POINT));
    }

    @Override
    public ServiceAccessPoint getServiceAccessPoint() {
        return MotorolaDataEncryptionHeader.getServiceAccessPoint(this.getMessage());
    }
}

