/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.header.motorola;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.header.ProprietaryDataHeader;
import io.github.dsheirer.module.decode.dmr.message.type.ApplicationType;
import io.github.dsheirer.module.decode.dmr.message.type.ServiceAccessPoint;
import io.github.dsheirer.module.decode.dmr.message.type.Vendor;

public class MNISProprietaryDataHeader
extends ProprietaryDataHeader {
    private static final int[] SERVICE_ACCESS_POINT = new int[]{0, 1, 2, 3};
    private static final int[] VENDOR = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] UNKNOWN_02 = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] MESSAGE_TYPE = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] APPLICATION_TYPE = new int[]{32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] PACKET_NUMBER = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int PACKET_PREFIX_START = 56;
    private static final int PACKET_PREFIX_END = 80;

    public MNISProprietaryDataHeader(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CC:").append(this.getSlotType().getColorCode());
        sb.append(" MOTOROLA MNIS HEADER");
        if (this.getApplicationType() == ApplicationType.UNKNOWN) {
            sb.append(" APPLICATION TYPE:0x").append(Integer.toHexString(this.getApplicationTypeNumber()).toUpperCase());
        } else {
            sb.append(" APPLICATION:").append((Object)this.getApplicationType());
        }
        sb.append(" PACKET:").append(this.getPacketNumber());
        sb.append(" PACKET PREFIX:").append(this.getPacketPrefix().toHexString());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public static Vendor getVendor(BinaryMessage message) {
        return Vendor.fromValue(message.getInt(VENDOR));
    }

    @Override
    public Vendor getVendor() {
        return MNISProprietaryDataHeader.getVendor(this.getMessage());
    }

    public static ServiceAccessPoint getServiceAccessPoint(CorrectedBinaryMessage message) {
        return ServiceAccessPoint.fromValue(message.getInt(SERVICE_ACCESS_POINT));
    }

    @Override
    public ServiceAccessPoint getServiceAccessPoint() {
        return MNISProprietaryDataHeader.getServiceAccessPoint(this.getMessage());
    }

    public static ApplicationType getApplicationType(CorrectedBinaryMessage message) {
        return ApplicationType.fromValue(message.getInt(APPLICATION_TYPE));
    }

    public ApplicationType getApplicationType() {
        return MNISProprietaryDataHeader.getApplicationType(this.getMessage());
    }

    public static int getApplicationTypeValue(CorrectedBinaryMessage message) {
        return message.getInt(APPLICATION_TYPE);
    }

    public int getApplicationTypeNumber() {
        return this.getMessage().getInt(APPLICATION_TYPE);
    }

    public int getPacketNumber() {
        return this.getMessage().getInt(PACKET_NUMBER);
    }

    @Override
    public CorrectedBinaryMessage getPacketPrefix() {
        return this.getMessage().getSubMessage(56, 80);
    }
}

