/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.header.hytera;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.header.ProprietaryDataHeader;
import io.github.dsheirer.module.decode.dmr.message.type.EncryptionAlgorithm;

public class HyteraDataEncryptionHeader
extends ProprietaryDataHeader {
    private static final int[] ALGORITHM = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] KEY = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] INITIALIZATION_VECTOR = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] UNKNOWN = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};

    public HyteraDataEncryptionHeader(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (!this.isValid()) {
            sb.append(" [CRC ERROR]");
        }
        sb.append(" HYTERA DATA ENCRYPTION HEADER - SAP:").append((Object)this.getServiceAccessPoint());
        switch (this.getAlgorithm()) {
            case NO_ENCRYPTION: {
                sb.append(" ALGORITHM:UNENCRYPTED");
                break;
            }
            case UNKNOWN: {
                sb.append(" ALGORITHM:").append(this.getMessage().getInt(ALGORITHM));
                break;
            }
            default: {
                sb.append(" ALGORITHM:").append((Object)this.getAlgorithm());
            }
        }
        if (this.getAlgorithm() != EncryptionAlgorithm.NO_ENCRYPTION) {
            sb.append(" KEY:").append(this.getKeyId());
            sb.append(" IV:").append(this.getIV());
            sb.append(" UNK:").append(this.getUnknown());
        }
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public EncryptionAlgorithm getAlgorithm() {
        return EncryptionAlgorithm.fromValue(this.getMessage().getInt(ALGORITHM));
    }

    public int getKeyId() {
        return this.getMessage().getInt(KEY);
    }

    public String getIV() {
        return this.getMessage().getHex(INITIALIZATION_VECTOR, 8);
    }

    public String getUnknown() {
        return this.getMessage().getHex(UNKNOWN, 4);
    }
}

