/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.header;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.header.OctetDataHeader;
import java.util.ArrayList;
import java.util.List;

public class UnconfirmedDataHeader
extends OctetDataHeader {
    private List<Identifier> mIdentifiers;

    public UnconfirmedDataHeader(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (!this.isValid()) {
            sb.append(" [CRC ERROR]");
        }
        sb.append(" UNCONFIRMED DATA HEADER");
        sb.append(" FM:").append(this.getSourceLLID());
        sb.append(" TO:").append(this.getDestinationLLID());
        sb.append(" ").append((Object)this.getServiceAccessPoint());
        sb.append(" BLOCKS TO FOLLOW:").append(this.getBlocksToFollow());
        sb.append(" FRAGMENT SEQUENCE NUMBER:").append(this.getFragmentSequenceNumber());
        if (this.isFinalFragment()) {
            sb.append("(FINAL)");
        }
        sb.append(" PAD OCTETS:").append(this.getPadOctetCount());
        return sb.toString();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getDestinationLLID());
            this.mIdentifiers.add(this.getSourceLLID());
        }
        return this.mIdentifiers;
    }
}

