/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.grant;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DMRRadio;
import io.github.dsheirer.module.decode.dmr.identifier.DMRTalkgroup;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.grant.ChannelGrant;
import io.github.dsheirer.module.decode.dmr.message.data.mbc.MBCContinuationBlock;
import java.util.ArrayList;
import java.util.List;

public class TalkgroupDataChannelGrant
extends ChannelGrant {
    private static final int EMERGENCY_FLAG = 30;
    private static final int HI_RATE_PACKET_CHANNEL_FLAG = 31;
    private List<Identifier> mIdentifiers;
    private RadioIdentifier mSourceRadio;
    private TalkgroupIdentifier mDestinationTalkgroup;

    public TalkgroupDataChannelGrant(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    public TalkgroupDataChannelGrant(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot, MBCContinuationBlock multiBlock) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot, multiBlock);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        if (this.isEmergency()) {
            sb.append(" EMERGENCY");
        }
        if (this.isEncrypted()) {
            sb.append(" ENCRYPTED");
        }
        if (this.isHighRatePacketChannel()) {
            sb.append(" DUAL-SLOT HI-RATE ");
        }
        sb.append(" TALKGROUP DATA CHANNEL GRANT FM:").append(this.getSourceRadio());
        sb.append(" TO:").append(this.getDestinationTalkgroup());
        sb.append(" ").append(this.getChannel());
        return sb.toString();
    }

    public boolean isHighRatePacketChannel() {
        return this.getMessage().get(31);
    }

    public boolean isEmergency() {
        return this.getMessage().get(30);
    }

    public RadioIdentifier getSourceRadio() {
        if (this.mSourceRadio == null) {
            this.mSourceRadio = DMRRadio.createFrom(this.getMessage().getInt(SOURCE));
        }
        return this.mSourceRadio;
    }

    public TalkgroupIdentifier getDestinationTalkgroup() {
        if (this.mDestinationTalkgroup == null) {
            this.mDestinationTalkgroup = DMRTalkgroup.create(this.getMessage().getInt(DESTINATION));
        }
        return this.mDestinationTalkgroup;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getChannel());
            this.mIdentifiers.add(this.getSourceRadio());
            this.mIdentifiers.add(this.getDestinationTalkgroup());
        }
        return this.mIdentifiers;
    }
}

