/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.grant;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DmrTier3Radio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.grant.ChannelGrant;
import io.github.dsheirer.module.decode.dmr.message.data.mbc.MBCContinuationBlock;
import java.util.ArrayList;
import java.util.List;

public class PrivateDataChannelGrant
extends ChannelGrant {
    private static final int EMERGENCY_FLAG = 30;
    private static final int HI_RATE_PACKET_CHANNEL_FLAG = 31;
    private List<Identifier> mIdentifiers;
    private RadioIdentifier mSourceRadio;
    private RadioIdentifier mDestinationRadio;

    public PrivateDataChannelGrant(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    public PrivateDataChannelGrant(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot, MBCContinuationBlock multiBlock) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot, multiBlock);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        if (this.isEmergency()) {
            sb.append(" EMERGENCY");
        }
        if (this.isEncrypted()) {
            sb.append(" ENCRYPTED");
        }
        if (this.isHighRatePacketChannel()) {
            sb.append(" DUAL-SLOT HI-RATE ");
        }
        sb.append(" PRIVATE DATA CHANNEL GRANT FM:").append(this.getSourceRadio());
        sb.append(" TO:").append(this.getDestinationRadio());
        sb.append(" ").append(this.getChannel());
        return sb.toString();
    }

    public boolean isHighRatePacketChannel() {
        return this.getMessage().get(31);
    }

    public boolean isEmergency() {
        return this.getMessage().get(30);
    }

    public RadioIdentifier getSourceRadio() {
        if (this.mSourceRadio == null) {
            this.mSourceRadio = DmrTier3Radio.createFrom(this.getMessage().getInt(SOURCE));
        }
        return this.mSourceRadio;
    }

    public RadioIdentifier getDestinationRadio() {
        if (this.mDestinationRadio == null) {
            this.mDestinationRadio = DmrTier3Radio.createTo(this.getMessage().getInt(DESTINATION));
        }
        return this.mDestinationRadio;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getChannel());
            this.mIdentifiers.add(this.getSourceRadio());
            this.mIdentifiers.add(this.getDestinationRadio());
        }
        return this.mIdentifiers;
    }
}

