/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.grant;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.channel.DMRChannel;
import io.github.dsheirer.module.decode.dmr.channel.DMRTier3Channel;
import io.github.dsheirer.module.decode.dmr.channel.ITimeslotFrequencyReceiver;
import io.github.dsheirer.module.decode.dmr.channel.TimeslotFrequency;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.data.mbc.MBCContinuationBlock;
import io.github.dsheirer.module.decode.dmr.message.type.AbsoluteChannelParameters;
import io.github.dsheirer.module.decode.dmr.message.type.DataType;
import java.util.List;

public abstract class ChannelGrant
extends CSBKMessage
implements ITimeslotFrequencyReceiver {
    private static final int[] CHANNEL_NUMBER = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27};
    private static final int[] TIMESLOT = new int[]{28};
    protected static final int[] DESTINATION = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    protected static final int[] SOURCE = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private DMRChannel mChannel;
    private AbsoluteChannelParameters mAbsoluteChannelParameters;

    public ChannelGrant(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    public ChannelGrant(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot, MBCContinuationBlock multiBlock) {
        this(syncPattern, message, cach, slotType, timestamp, timeslot);
        if (multiBlock != null) {
            this.mAbsoluteChannelParameters = new AbsoluteChannelParameters(multiBlock.getMessage(), 0, this.getChannelGrantTimeslot());
        }
    }

    @Override
    public void checkCRC() {
        if (this.getSlotType().getDataType() == DataType.MBC_HEADER) {
            this.checkMultiBlockCRC(this.getAbsoluteChannelParameters());
        } else {
            super.checkCRC();
        }
    }

    private int getChannelGrantTimeslot() {
        return this.getMessage().getInt(TIMESLOT) + 1;
    }

    private int getChannelNumber() {
        return this.getMessage().getInt(CHANNEL_NUMBER);
    }

    public AbsoluteChannelParameters getAbsoluteChannelParameters() {
        return this.mAbsoluteChannelParameters;
    }

    public boolean hasAbsoluteChannelParameters() {
        return this.getAbsoluteChannelParameters() != null;
    }

    public DMRChannel getChannel() {
        if (this.hasAbsoluteChannelParameters()) {
            return this.mAbsoluteChannelParameters.getChannel();
        }
        if (this.mChannel == null) {
            this.mChannel = new DMRTier3Channel(this.getChannelNumber(), this.getChannelGrantTimeslot());
        }
        return this.mChannel;
    }

    @Override
    public int[] getLogicalChannelNumbers() {
        if (this.getChannel() != null) {
            return this.getChannel().getLogicalChannelNumbers();
        }
        return new int[0];
    }

    @Override
    public void apply(List<TimeslotFrequency> timeslotFrequencies) {
        if (this.getChannel() != null) {
            this.getChannel().apply(timeslotFrequencies);
        }
    }
}

