/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DmrTier3Radio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement.Announcement;
import java.util.ArrayList;
import java.util.List;

public class MassRegistration
extends Announcement {
    private static final int[] RESERVED = new int[]{21, 22, 23, 24, 25};
    private static final int[] REGISTRATION_WINDOW = new int[]{26, 27, 28, 39};
    private static final int[] ALOHA_MASK = new int[]{30, 31, 32, 33, 34};
    private static final int[] DESTINATION_RADIO = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private List<Identifier> mIdentifiers;
    private RadioIdentifier mDestinationRadio;

    public MassRegistration(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        sb.append(" MASS REGISTRATION");
        if (this.hasDestinationRadio()) {
            sb.append(" TO:").append(this.getDestinationRadio());
        }
        sb.append(" ").append((Object)this.getSystemIdentityCode().getModel());
        sb.append(" NETWORK:").append(this.getSystemIdentityCode().getNetwork());
        sb.append(" SITE:").append(this.getSystemIdentityCode().getSite());
        return sb.toString();
    }

    public boolean hasDestinationRadio() {
        return this.getMessage().getInt(DESTINATION_RADIO) != 0;
    }

    public RadioIdentifier getDestinationRadio() {
        if (this.mDestinationRadio == null) {
            this.mDestinationRadio = DmrTier3Radio.createTo(this.getMessage().getInt(DESTINATION_RADIO));
        }
        return this.mDestinationRadio;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.hasDestinationRadio()) {
                this.mIdentifiers.add(this.getDestinationRadio());
            }
            this.mIdentifiers.add(this.getSystemIdentityCode().getNetwork());
            this.mIdentifiers.add(this.getSystemIdentityCode().getSite());
        }
        return this.mIdentifiers;
    }
}

