/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement.Announcement;
import java.util.ArrayList;
import java.util.List;

public class CallTimerParameters
extends Announcement {
    private static final int[] EMERGENCY_TIMER = new int[]{21, 22, 23, 24, 25, 26, 27, 28, 29};
    private static final int[] PACKET_TIMER = new int[]{30, 31, 32, 33, 34};
    private static final int[] MOBILE_TO_MOBILE_TIMER = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67};
    private static final int[] MOBILE_TO_LINE_TIMER = new int[]{68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private List<Identifier> mIdentifiers;

    public CallTimerParameters(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        sb.append(" CALL TIMERS EMERG:").append(this.getEmergencyTimerDecoded());
        sb.append(" PACKET:").append(this.getPacketTimerDecoded());
        sb.append(" MS-MS:").append(this.getMobileToMobileTimerDecoded());
        sb.append(" MS-LINE:").append(this.getMobileToLineTimerDecoded());
        sb.append(" ").append((Object)this.getSystemIdentityCode().getModel());
        sb.append(" NETWORK:").append(this.getSystemIdentityCode().getNetwork());
        sb.append(" SITE:").append(this.getSystemIdentityCode().getSite());
        return sb.toString();
    }

    public int getEmergencyTimer() {
        return this.getMessage().getInt(EMERGENCY_TIMER);
    }

    public String getEmergencyTimerDecoded() {
        int timer = this.getEmergencyTimer();
        if (timer == 0) {
            return "INTERNAL";
        }
        if (1 <= timer && timer <= 10) {
            return timer + " SECS";
        }
        if (11 <= timer && timer <= 20) {
            return (timer - 8) * 5 + " SECS";
        }
        if (21 <= timer && timer <= 28) {
            return (timer - 16) * 15 + " SECS";
        }
        if (29 <= timer && timer <= 40) {
            return (double)(timer - 22) * 0.5 + " MINS";
        }
        if (41 <= timer && timer <= 51) {
            return timer - 31 + " MINS";
        }
        if (52 <= timer && timer <= 510) {
            return (timer - 47) * 5 + " MINS";
        }
        return "INFINITY";
    }

    public int getPacketTimer() {
        return this.getMessage().getInt(PACKET_TIMER);
    }

    public String getPacketTimerDecoded() {
        int timer = this.getPacketTimer();
        if (timer == 0) {
            return "INTERNAL";
        }
        if (1 <= timer && timer <= 5) {
            return timer + " SECS";
        }
        if (6 <= timer && timer <= 10) {
            return (timer - 4) * 5 + " SECS";
        }
        if (11 <= timer && timer <= 12) {
            return (timer - 8) * 15 + " SECS";
        }
        if (13 <= timer && timer <= 20) {
            return (double)(timer - 10) * 0.5 + " MINS";
        }
        if (21 <= timer && timer <= 25) {
            return timer - 15 + " MINS";
        }
        if (26 <= timer && timer <= 30) {
            return (timer - 23) * 5 + " MINS";
        }
        return "INFINITY";
    }

    public int getMobileToMobileTimer() {
        return this.getMessage().getInt(MOBILE_TO_MOBILE_TIMER);
    }

    public String getMobileToMobileTimerDecoded() {
        int timer = this.getMobileToMobileTimer();
        if (timer == 0) {
            return "INTERNAL";
        }
        if (1 <= timer && timer <= 59) {
            return timer + " SECS";
        }
        if (60 <= timer && timer <= 107) {
            return (timer - 48) * 5 + " SECS";
        }
        if (108 <= timer && timer <= 138) {
            return (double)(timer - 98) * 0.5 + " MINS";
        }
        if (139 <= timer && timer <= 4094) {
            return timer - 118 + " MINS";
        }
        return "INFINITY";
    }

    public int getMobileToLineTimer() {
        return this.getMessage().getInt(MOBILE_TO_LINE_TIMER);
    }

    public String getMobileToLineTimerDecoded() {
        int timer = this.getMobileToLineTimer();
        if (timer == 0) {
            return "INTERNAL";
        }
        if (1 <= timer && timer <= 59) {
            return timer + " SECS";
        }
        if (60 <= timer && timer <= 107) {
            return (timer - 48) * 5 + " SECS";
        }
        if (108 <= timer && timer <= 138) {
            return (double)(timer - 98) * 0.5 + " MINS";
        }
        if (139 <= timer && timer <= 4094) {
            return timer - 118 + " MINS";
        }
        return "INFINITY";
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getSystemIdentityCode().getNetwork());
            this.mIdentifiers.add(this.getSystemIdentityCode().getSite());
        }
        return this.mIdentifiers;
    }
}

