/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.ahoy;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DMRRadio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.ahoy.Ahoy;
import io.github.dsheirer.module.decode.dmr.message.type.Tier3Gateway;
import java.util.ArrayList;
import java.util.List;

public class StunReviveKill
extends Ahoy {
    private RadioIdentifier mSourceRadio;
    private List<Identifier> mIdentifiers;

    public StunReviveKill(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        if (this.isEncrypted()) {
            sb.append(" ENCRYPTED");
        }
        sb.append(" ").append(this.getCommand()).append(" RADIO:").append(this.getTargetAddress());
        sb.append(" FM:").append(this.getSourceRadio());
        return sb.toString();
    }

    public Tier3Gateway getGateway() {
        return Tier3Gateway.fromValue(this.getMultiPurposeFieldValue());
    }

    public String getCommand() {
        switch (this.getGateway()) {
            case KILLI: {
                return "KILL";
            }
            case STUNI: {
                if (this.isStunCommand()) {
                    return "STUN";
                }
                return "REVIVE";
            }
        }
        return "UNKNOWN";
    }

    public boolean isStunCommand() {
        return !this.getMessage().get(23);
    }

    public boolean isReviveCommand() {
        return !this.getMessage().get(23);
    }

    public RadioIdentifier getSourceRadio() {
        if (this.mSourceRadio == null) {
            this.mSourceRadio = DMRRadio.createFrom(this.getMultiPurposeFieldValue());
        }
        return this.mSourceRadio;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetAddress());
            this.mIdentifiers.add(this.getSourceRadio());
        }
        return this.mIdentifiers;
    }
}

