/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.ahoy;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DMRRadio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.ahoy.Ahoy;
import java.util.ArrayList;
import java.util.List;

public class ServiceRadioCheck
extends Ahoy {
    private RadioIdentifier mSourceRadio;
    private List<Identifier> mIdentifiers;

    public ServiceRadioCheck(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        if (this.isEncrypted()) {
            sb.append(" ENCRYPTED");
        }
        sb.append(" ").append(this.getServiceDescription());
        sb.append(" SERVICE RADIO CHECK (").append(this.isTalkgroupTarget() ? "TALKGROUP" : "INDIVIDUAL");
        sb.append(") TO:").append(this.getTargetAddress());
        sb.append(" FM:").append(this.getSourceRadio());
        return sb.toString();
    }

    public String getServiceDescription() {
        switch (this.getServiceKind()) {
            case FULL_DUPLEX_MS_TO_MS_PACKET_CALL_SERVICE: 
            case INDIVIDUAL_PACKET_CALL_SERVICE: 
            case TALKGROUP_PACKET_CALL_SERVICE: {
                return "PACKET";
            }
            case INDIVIDUAL_UDT_SHORT_DATA_CALL_SERVICE: 
            case TALKGROUP_UDT_SHORT_DATA_CALL_SERVICE: {
                return "SHORT DATA";
            }
            case FULL_DUPLEX_MS_TO_MS_VOICE_CALL_SERVICE: 
            case INDIVIDUAL_VOICE_CALL_SERVICE: 
            case TALKGROUP_VOICE_CALL_SERVICE: {
                return "VOICE";
            }
        }
        return "UNKNOWN";
    }

    public RadioIdentifier getSourceRadio() {
        if (this.mSourceRadio == null) {
            this.mSourceRadio = DMRRadio.createFrom(this.getMultiPurposeFieldValue());
        }
        return this.mSourceRadio;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetAddress());
            this.mIdentifiers.add(this.getSourceRadio());
        }
        return this.mIdentifiers;
    }
}

