/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.acknowledge;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.acknowledge.Acknowledge;

public class RegistrationAccepted
extends Acknowledge {
    public RegistrationAccepted(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    public int getPowerSaveOffset() {
        return this.getMessage().getInt(RESPONSE_INFO);
    }

    public boolean hasPowerSaveOffset() {
        return this.getPowerSaveOffset() > 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        sb.append(" REGISTRATION ACCEPTED TO:").append(this.getTargetAddress());
        sb.append(" FM:").append(this.getSourceRadio());
        if (this.hasPowerSaveOffset()) {
            sb.append(" POWER SAVE OFFSET:").append(this.getPowerSaveOffset());
        }
        return sb.toString();
    }
}

