/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.standard;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.integer.IntegerIdentifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DMRTalkgroup;
import io.github.dsheirer.module.decode.dmr.identifier.DmrTier3Radio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.type.ProtectKind;
import java.util.ArrayList;
import java.util.List;

public class Protect
extends CSBKMessage {
    private static final int[] PROTECT_KIND = new int[]{28, 29, 30};
    private static final int TALKGROUP_FLAG = 31;
    protected static final int[] DESTINATION = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    protected static final int[] SOURCE = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private List<Identifier> mIdentifiers;
    private RadioIdentifier mSourceRadio;
    private IntegerIdentifier mDestinationId;

    public Protect(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        if (this.isEncrypted()) {
            sb.append(" ENCRYPTED");
        }
        sb.append(" PROTECT: ").append((Object)this.getProtectKind());
        sb.append(" FM:").append(this.getSourceRadio());
        sb.append(" TO:").append(this.getDestinationId());
        return sb.toString();
    }

    public ProtectKind getProtectKind() {
        return ProtectKind.fromValue(this.getMessage().getInt(PROTECT_KIND));
    }

    public RadioIdentifier getSourceRadio() {
        if (this.mSourceRadio == null) {
            this.mSourceRadio = DmrTier3Radio.createFrom(this.getMessage().getInt(SOURCE));
        }
        return this.mSourceRadio;
    }

    public IntegerIdentifier getDestinationId() {
        if (this.mDestinationId == null) {
            this.mDestinationId = this.getMessage().get(31) ? DMRTalkgroup.create(this.getMessage().getInt(DESTINATION)) : DmrTier3Radio.createTo(this.getMessage().getInt(DESTINATION));
        }
        return this.mDestinationId;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getSourceRadio());
            this.mIdentifiers.add(this.getDestinationId());
        }
        return this.mIdentifiers;
    }
}

