/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.standard;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.integer.IntegerIdentifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DMRTalkgroup;
import io.github.dsheirer.module.decode.dmr.identifier.DmrTier3Radio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import java.util.ArrayList;
import java.util.List;

public class Preamble
extends CSBKMessage {
    private static final int DATA_CSBK_FLAG = 16;
    private static final int RADIO_TALKGROUP_FLAG = 17;
    private static final int[] BLOCKS_TO_FOLLOW = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] TARGET_ADDRESS = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] SOURCE_ADDRESS = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private IntegerIdentifier mTargetAddress;
    private RadioIdentifier mSourceAddress;
    private List<Identifier> mIdentifiers;

    public Preamble(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" CSBK PREAMBLE FM:").append(this.getSourceAddress());
        sb.append(" TO:").append(this.getTargetAddress());
        sb.append(this.isCSBKPreamble() ? " CSBK" : " DATA");
        sb.append(" BLOCKS TO FOLLOW:").append(this.getBlocksToFollow());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public boolean isTalkgroupTargetAddress() {
        return this.getMessage().get(17);
    }

    public boolean isDataPreamble() {
        return this.getMessage().get(16);
    }

    public boolean isCSBKPreamble() {
        return !this.getMessage().get(16);
    }

    public int getBlocksToFollow() {
        return this.getMessage().getInt(BLOCKS_TO_FOLLOW);
    }

    public IntegerIdentifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = this.isTalkgroupTargetAddress() ? DMRTalkgroup.create(this.getMessage().getInt(TARGET_ADDRESS)) : DmrTier3Radio.createTo(this.getMessage().getInt(TARGET_ADDRESS));
        }
        return this.mTargetAddress;
    }

    public RadioIdentifier getSourceAddress() {
        if (this.mSourceAddress == null) {
            this.mSourceAddress = DmrTier3Radio.createFrom(this.getMessage().getInt(SOURCE_ADDRESS));
        }
        return this.mSourceAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetAddress());
            this.mIdentifiers.add(this.getSourceAddress());
        }
        return this.mIdentifiers;
    }
}

