/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.channel.DMRLsn;
import io.github.dsheirer.module.decode.dmr.channel.ITimeslotFrequencyReceiver;
import io.github.dsheirer.module.decode.dmr.channel.TimeslotFrequency;
import io.github.dsheirer.module.decode.dmr.identifier.DMRRadio;
import io.github.dsheirer.module.decode.dmr.identifier.DMRTalkgroup;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import java.util.ArrayList;
import java.util.List;

public class ConnectPlusVoiceChannelUser
extends CSBKMessage
implements ITimeslotFrequencyReceiver {
    private static final int[] SOURCE_ADDRESS = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] GROUP_ADDRESS = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] LOGICAL_SLOT_NUMBER = new int[]{64, 65, 66, 67, 68};
    private static final int[] UNKNOWN_FIELD = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private RadioIdentifier mRadio;
    private TalkgroupIdentifier mTalkgroup;
    private DMRLsn mDmrLsn;
    private List<Identifier> mIdentifiers;

    public ConnectPlusVoiceChannelUser(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" CSBK CON+ VOICE CHANNEL USER FM:").append(this.getRadio());
        sb.append(" TO:").append(this.getTalkgroup());
        sb.append(" ").append(this.getChannel());
        sb.append(" UNK:").append(this.getUnknownField());
        return sb.toString();
    }

    public RadioIdentifier getRadio() {
        if (this.mRadio == null) {
            this.mRadio = DMRRadio.createFrom(this.getMessage().getInt(SOURCE_ADDRESS));
        }
        return this.mRadio;
    }

    public TalkgroupIdentifier getTalkgroup() {
        if (this.mTalkgroup == null) {
            this.mTalkgroup = DMRTalkgroup.create(this.getMessage().getInt(GROUP_ADDRESS));
        }
        return this.mTalkgroup;
    }

    public int getUnknownField() {
        return this.getMessage().getInt(UNKNOWN_FIELD);
    }

    public int getTrafficLsn() {
        return this.getMessage().getInt(LOGICAL_SLOT_NUMBER) - 1;
    }

    public DMRLsn getChannel() {
        if (this.mDmrLsn == null) {
            this.mDmrLsn = new DMRLsn(this.getTrafficLsn());
        }
        return this.mDmrLsn;
    }

    @Override
    public int[] getLogicalChannelNumbers() {
        return this.getChannel().getLogicalChannelNumbers();
    }

    @Override
    public void apply(List<TimeslotFrequency> timeslotFrequencies) {
        this.getChannel().apply(timeslotFrequencies);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTalkgroup());
            this.mIdentifiers.add(this.getRadio());
            this.mIdentifiers.add(this.getChannel());
        }
        return this.mIdentifiers;
    }
}

