/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DMRRadio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import java.util.ArrayList;
import java.util.List;

public class ConnectPlusTerminateChannelGrant
extends CSBKMessage {
    private static final int[] TARGET_ADDRESS = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] UNKNOWN_FIELD_1 = new int[]{40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] UNKNOWN_FIELD_2 = new int[]{48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] UNKNOWN_FIELD_3 = new int[]{56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] UNKNOWN_FIELD_4 = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] UNKNOWN_FIELD_5 = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private RadioIdentifier mTargetRadio;
    private List<Identifier> mIdentifiers;

    public ConnectPlusTerminateChannelGrant(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" CSBK ").append((Object)this.getVendor());
        sb.append(" TERMINATE CHANNEL GRANT TO:").append(this.getTargetRadio());
        sb.append(" U1:").append(this.getUnknownField1());
        sb.append(" U2:").append(this.getUnknownField2());
        sb.append(" U3:").append(this.getUnknownField3());
        sb.append(" U4:").append(this.getUnknownField4());
        sb.append(" U5:").append(this.getUnknownField5());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public RadioIdentifier getTargetRadio() {
        if (this.mTargetRadio == null) {
            this.mTargetRadio = DMRRadio.createTo(this.getMessage().getInt(TARGET_ADDRESS));
        }
        return this.mTargetRadio;
    }

    public int getUnknownField1() {
        return this.getMessage().getInt(UNKNOWN_FIELD_1);
    }

    public int getUnknownField2() {
        return this.getMessage().getInt(UNKNOWN_FIELD_2);
    }

    public int getUnknownField3() {
        return this.getMessage().getInt(UNKNOWN_FIELD_3);
    }

    public int getUnknownField4() {
        return this.getMessage().getInt(UNKNOWN_FIELD_4);
    }

    public int getUnknownField5() {
        return this.getMessage().getInt(UNKNOWN_FIELD_5);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetRadio());
        }
        return this.mIdentifiers;
    }
}

