/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DMRRadio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import java.util.ArrayList;
import java.util.List;

public class ConnectPlusRegistrationRequest
extends CSBKMessage {
    private static final int[] SOURCE_ADDRESS = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] TARGET_ADDRESS = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] UNKNOWN = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private List<Identifier> mIdentifiers;
    private RadioIdentifier mSourceRadio;
    private RadioIdentifier mTargetRadio;

    public ConnectPlusRegistrationRequest(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" CSBK CON+ REGISTRATION REQUEST FM:").append(this.getSourceRadio());
        sb.append(" TO:").append(this.getTargetRadio());
        sb.append(" UNK:").append(this.getUnknown());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public int getUnknown() {
        return this.getMessage().getInt(UNKNOWN);
    }

    public RadioIdentifier getSourceRadio() {
        if (this.mSourceRadio == null) {
            this.mSourceRadio = DMRRadio.createFrom(this.getMessage().getInt(SOURCE_ADDRESS));
        }
        return this.mSourceRadio;
    }

    public RadioIdentifier getTargetRadio() {
        if (this.mTargetRadio == null) {
            this.mTargetRadio = DMRRadio.createTo(this.getMessage().getInt(TARGET_ADDRESS));
        }
        return this.mTargetRadio;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getSourceRadio());
            this.mIdentifiers.add(this.getTargetRadio());
        }
        return this.mIdentifiers;
    }
}

