/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.channel.DMRLsn;
import io.github.dsheirer.module.decode.dmr.channel.ITimeslotFrequencyReceiver;
import io.github.dsheirer.module.decode.dmr.channel.TimeslotFrequency;
import io.github.dsheirer.module.decode.dmr.identifier.DMRRadio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import java.util.ArrayList;
import java.util.List;

public class ConnectPlusDataChannelGrant
extends CSBKMessage
implements ITimeslotFrequencyReceiver {
    private static final int[] TARGET_ADDRESS = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] LOGICAL_SLOT_NUMBER = new int[]{40, 41, 42, 43, 44};
    private static final int[] UNKNOWN_FIELD = new int[]{48, 49, 50, 51, 52, 53, 54, 55};
    private RadioIdentifier mTargetRadio;
    private DMRLsn mDmrLsn;
    private List<Identifier> mIdentifiers;

    public ConnectPlusDataChannelGrant(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" CSBK ").append((Object)this.getVendor());
        sb.append(" DATA CHANNEL GRANT TO:").append(this.getTargetRadio());
        sb.append(" ").append(this.getChannel());
        sb.append(" UNK:").append(this.getUnknownField());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public RadioIdentifier getTargetRadio() {
        if (this.mTargetRadio == null) {
            this.mTargetRadio = DMRRadio.createTo(this.getMessage().getInt(TARGET_ADDRESS));
        }
        return this.mTargetRadio;
    }

    public int getUnknownField() {
        return this.getMessage().getInt(UNKNOWN_FIELD);
    }

    public int getLsn() {
        return this.getMessage().getInt(LOGICAL_SLOT_NUMBER) - 1;
    }

    public DMRLsn getChannel() {
        if (this.mDmrLsn == null) {
            this.mDmrLsn = new DMRLsn(this.getLsn());
        }
        return this.mDmrLsn;
    }

    @Override
    public int[] getLogicalChannelNumbers() {
        return this.getChannel().getLogicalChannelNumbers();
    }

    @Override
    public void apply(List<TimeslotFrequency> timeslotFrequencies) {
        this.getChannel().apply(timeslotFrequencies);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetRadio());
            this.mIdentifiers.add(this.getChannel());
        }
        return this.mIdentifiers;
    }
}

