/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.channel.DmrRestLsn;
import io.github.dsheirer.module.decode.dmr.channel.ITimeslotFrequencyReceiver;
import io.github.dsheirer.module.decode.dmr.channel.TimeslotFrequency;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.SegmentIndicator;
import java.util.ArrayList;
import java.util.List;

public class CapacityPlusSiteStatus
extends CSBKMessage
implements ITimeslotFrequencyReceiver {
    private static final int[] BYTE = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] TWO_BYTES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] SEGMENT_INDICATOR = new int[]{16, 17};
    private static final int[] REST_LSN = new int[]{19, 20, 21, 22, 23};
    private static final int[] LSN_VOICE_BITMAP = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int LSN_1_8_BITMAP_START = 24;
    private DmrRestLsn mRestChannel;
    private List<Identifier> mIdentifiers;

    public CapacityPlusSiteStatus(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" CSBK CAP+ SITE STATUS ").append(this.getRestChannel());
        sb.append(" ").append((Object)this.getSegmentIndicator());
        sb.append(" ");
        if (this.getSegmentIndicator().isFirst()) {
            sb.append(this.getActivityFragments());
        } else {
            sb.append("CONTINUATION BLOCK");
        }
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    private boolean hasVoiceTalkgroups() {
        return this.getSegmentIndicator().isFirst() && this.getMessage().getInt(LSN_VOICE_BITMAP) > 0;
    }

    private String getActivityFragments() {
        int lsn;
        int x;
        if (this.getMessage().get(48) && this.getMessage().get(56)) {
            boolean bl = false;
        }
        int[] talkgroups = new int[17];
        int[] radios = new int[17];
        boolean hasIdentifier = false;
        int pointer = 24;
        if (this.getMessage().getInt(BYTE, pointer) > 0) {
            int lowLsnBitmap = pointer;
            pointer += 8;
            for (x = lowLsnBitmap; x < lowLsnBitmap + 8; ++x) {
                lsn = x - lowLsnBitmap + 1;
                if (!this.getMessage().get(x)) continue;
                hasIdentifier = true;
                if (pointer <= 72) {
                    talkgroups[lsn] = this.getMessage().getInt(BYTE, pointer);
                    pointer += 8;
                    continue;
                }
                talkgroups[lsn] = -1;
            }
        } else {
            pointer += 8;
        }
        if (pointer <= 72 && this.getMessage().getInt(BYTE, pointer) > 0) {
            hasIdentifier = true;
            int highLsnBitmap = pointer;
            pointer += 8;
            for (x = highLsnBitmap; x < highLsnBitmap + 8; ++x) {
                lsn = x - highLsnBitmap + 1 + 8;
                if (!this.getMessage().get(x)) continue;
                if (pointer <= 72) {
                    talkgroups[lsn] = this.getMessage().getInt(BYTE, pointer);
                    pointer += 8;
                    continue;
                }
                talkgroups[lsn] = -1;
            }
        } else {
            pointer += 8;
        }
        if (pointer <= 72 && this.getMessage().get(pointer)) {
            hasIdentifier = true;
            if ((pointer += 8) <= 72 && this.getMessage().getInt(BYTE, pointer) > 0) {
                int lowDataLsnBitmap = pointer;
                pointer += 8;
                for (x = lowDataLsnBitmap; x < lowDataLsnBitmap + 8; ++x) {
                    lsn = x - lowDataLsnBitmap + 1;
                    if (!this.getMessage().get(x)) continue;
                    if (pointer <= 64) {
                        radios[lsn] = this.getMessage().getInt(TWO_BYTES, pointer);
                        pointer += 16;
                        continue;
                    }
                    radios[lsn] = -1;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        if (!hasIdentifier) {
            sb.append("IDLE LSN: 1-16");
        } else {
            sb.append("ACTIVE LSN");
            for (x = 1; x < 17; ++x) {
                if (talkgroups[x] == 0 && radios[x] == 0) continue;
                sb.append(" ").append(x);
                if (talkgroups[x] == 0) {
                    if (radios[x] < 0) {
                        sb.append(":(R)A");
                        continue;
                    }
                    if (radios[x] > 0) {
                        sb.append(":(R)").append(radios[x]);
                        continue;
                    }
                    sb.append(":");
                    continue;
                }
                if (talkgroups[x] < 0) {
                    sb.append(":(T)A");
                    continue;
                }
                sb.append(":(T)").append(talkgroups[x]);
            }
        }
        return sb.toString();
    }

    public SegmentIndicator getSegmentIndicator() {
        return SegmentIndicator.fromValue(this.getMessage().getInt(SEGMENT_INDICATOR));
    }

    public DmrRestLsn getRestChannel() {
        if (this.mRestChannel == null) {
            this.mRestChannel = new DmrRestLsn(this.getRestLSN());
        }
        return this.mRestChannel;
    }

    public int getRestLSN() {
        return this.getMessage().getInt(REST_LSN);
    }

    @Override
    public int[] getLogicalChannelNumbers() {
        return this.getRestChannel().getLogicalChannelNumbers();
    }

    @Override
    public void apply(List<TimeslotFrequency> timeslotFrequencies) {
        this.getRestChannel().apply(timeslotFrequencies);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getRestChannel());
        }
        return this.mIdentifiers;
    }
}

