/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.channel.DmrRestLsn;
import io.github.dsheirer.module.decode.dmr.channel.ITimeslotFrequencyReceiver;
import io.github.dsheirer.module.decode.dmr.channel.TimeslotFrequency;
import io.github.dsheirer.module.decode.dmr.identifier.DMRSite;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.type.LCSS;
import java.util.ArrayList;
import java.util.List;

public class CapacityPlusNeighbors
extends CSBKMessage
implements ITimeslotFrequencyReceiver {
    private static final int[] LC_START_STOP = new int[]{16, 17};
    private static final int[] REST_LSN = new int[]{19, 20, 21, 22, 23};
    private static final int ASYNC = 24;
    private static final int[] SITE = new int[]{25, 26, 27, 28};
    private static final int[] NEIGHBOR_COUNT = new int[]{29, 30, 31};
    private static final int[] NEIGHBOR_1_SITE = new int[]{32, 33, 34, 35};
    private static final int[] NEIGHBOR_1_REST = new int[]{36, 37, 38, 39};
    private static final int[] NEIGHBOR_2_SITE = new int[]{40, 41, 42, 43};
    private static final int[] NEIGHBOR_2_REST = new int[]{44, 45, 46, 47};
    private static final int[] NEIGHBOR_3_SITE = new int[]{48, 49, 50, 51};
    private static final int[] NEIGHBOR_3_REST = new int[]{52, 53, 54, 55};
    private static final int[] NEIGHBOR_4_SITE = new int[]{56, 57, 58, 59};
    private static final int[] NEIGHBOR_4_REST = new int[]{60, 61, 62, 63};
    private static final int[] NEIGHBOR_5_SITE = new int[]{64, 65, 66, 67};
    private static final int[] NEIGHBOR_5_REST = new int[]{68, 69, 70, 71};
    private static final int[] NEIGHBOR_6_SITE = new int[]{72, 73, 74, 75};
    private static final int[] NEIGHBOR_6_REST = new int[]{76, 77, 78, 79};
    private DmrRestLsn mRestChannel;
    private DMRSite mSite;
    private List<Identifier> mIdentifiers;

    public CapacityPlusNeighbors(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" CSBK CAP+ SITE:").append(this.getSite());
        sb.append(" REST ").append(this.getRestChannel());
        sb.append(" FL:").append((Object)this.getLCSS());
        if (this.hasNeighbor(1)) {
            sb.append(" NEIGHBORS SITE:").append(this.getNeighbor1Site());
            sb.append("-REST:").append(this.getNeighbor1Rest());
            if (this.hasNeighbor(2)) {
                sb.append(" SITE:").append(this.getNeighbor2Site());
                sb.append("-REST:").append(this.getNeighbor2Rest());
                if (this.hasNeighbor(3)) {
                    sb.append(" SITE:").append(this.getNeighbor3Site());
                    sb.append("-REST:").append(this.getNeighbor3Rest());
                    if (this.hasNeighbor(4)) {
                        sb.append(" SITE:").append(this.getNeighbor4Site());
                        sb.append("-REST:").append(this.getNeighbor4Rest());
                        if (this.hasNeighbor(5)) {
                            sb.append(" SITE:").append(this.getNeighbor5Site());
                            sb.append("-REST:").append(this.getNeighbor5Rest());
                            if (this.hasNeighbor(6)) {
                                sb.append(" SITE:").append(this.getNeighbor6Site());
                                sb.append("-REST:").append(this.getNeighbor6Rest());
                            }
                        }
                    }
                }
            }
        }
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public boolean hasNeighbor(int neighbor) {
        return neighbor <= this.getNeighborCount();
    }

    public int getNeighborCount() {
        return this.getMessage().getInt(NEIGHBOR_COUNT);
    }

    public int getNeighbor1Site() {
        return this.getMessage().getInt(NEIGHBOR_1_SITE);
    }

    public int getNeighbor1Rest() {
        return this.getMessage().getInt(NEIGHBOR_1_REST);
    }

    public int getNeighbor2Site() {
        return this.getMessage().getInt(NEIGHBOR_2_SITE);
    }

    public int getNeighbor2Rest() {
        return this.getMessage().getInt(NEIGHBOR_2_REST);
    }

    public int getNeighbor3Site() {
        return this.getMessage().getInt(NEIGHBOR_3_SITE);
    }

    public int getNeighbor3Rest() {
        return this.getMessage().getInt(NEIGHBOR_3_REST);
    }

    public int getNeighbor4Site() {
        return this.getMessage().getInt(NEIGHBOR_4_SITE);
    }

    public int getNeighbor4Rest() {
        return this.getMessage().getInt(NEIGHBOR_4_REST);
    }

    public int getNeighbor5Site() {
        return this.getMessage().getInt(NEIGHBOR_5_SITE);
    }

    public int getNeighbor5Rest() {
        return this.getMessage().getInt(NEIGHBOR_5_REST);
    }

    public int getNeighbor6Site() {
        return this.getMessage().getInt(NEIGHBOR_6_SITE);
    }

    public int getNeighbor6Rest() {
        return this.getMessage().getInt(NEIGHBOR_6_REST);
    }

    public DMRSite getSite() {
        if (this.mSite == null) {
            this.mSite = DMRSite.create(this.getMessage().getInt(SITE));
        }
        return this.mSite;
    }

    public String getBeacon() {
        return this.getMessage().get(24) ? "ASYNC" : "PERIODIC";
    }

    public LCSS getLCSS() {
        return LCSS.fromValue(this.getMessage().getInt(LC_START_STOP));
    }

    public int getRestLSN() {
        return this.getMessage().getInt(REST_LSN);
    }

    public DmrRestLsn getRestChannel() {
        if (this.mRestChannel == null) {
            this.mRestChannel = new DmrRestLsn(this.getRestLSN());
        }
        return this.mRestChannel;
    }

    @Override
    public int[] getLogicalChannelNumbers() {
        return this.getRestChannel().getLogicalChannelNumbers();
    }

    @Override
    public void apply(List<TimeslotFrequency> timeslotFrequencies) {
        this.getRestChannel().apply(timeslotFrequencies);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getRestChannel());
        }
        return this.mIdentifiers;
    }
}

