/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.hytera;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import java.util.ArrayList;
import java.util.List;

public class HyteraXPTSiteState
extends CSBKMessage {
    private static final int[] SEQUENCE_NUMBER = new int[]{0, 1};
    private static final int[] FREE_REPEATER = new int[]{16, 17, 18, 19};
    private static final int[] REPEATER_A_STATE = new int[]{20, 21, 22, 23};
    private static final int[] REPEATER_B_STATE = new int[]{24, 25, 26, 27};
    private static final int[] REPEATER_C_STATE = new int[]{28, 29, 30, 31};
    private static final int[] REPEATER_A_TS0_ADDRESS = new int[]{32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] REPEATER_A_TS1_ADDRESS = new int[]{40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] REPEATER_B_TS0_ADDRESS = new int[]{48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] REPEATER_B_TS1_ADDRESS = new int[]{56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] REPEATER_C_TS0_ADDRESS = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] REPEATER_C_TS1_ADDRESS = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private List<Identifier> mIdentifiers;

    public HyteraXPTSiteState(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    public int getSequenceNumber() {
        return this.getMessage().getInt(SEQUENCE_NUMBER);
    }

    public boolean isAllChannelsBusy() {
        return this.getFreeRepeater() == 0;
    }

    public int getFreeRepeater() {
        return this.getMessage().getInt(FREE_REPEATER);
    }

    public int getRepeaterANumber() {
        switch (this.getSequenceNumber()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 7;
            }
        }
        return 0;
    }

    public int getRepeaterBNumber() {
        switch (this.getSequenceNumber()) {
            case 0: {
                return 2;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 8;
            }
        }
        return 0;
    }

    public int getRepeaterCNumber() {
        switch (this.getSequenceNumber()) {
            case 0: {
                return 3;
            }
            case 1: {
                return 6;
            }
            case 2: {
                return 9;
            }
        }
        return 0;
    }

    public int getRepeaterAStateInfo() {
        return this.getMessage().getInt(REPEATER_A_STATE);
    }

    public int getRepeaterBStateInfo() {
        return this.getMessage().getInt(REPEATER_B_STATE);
    }

    public int getRepeaterCStateInfo() {
        return this.getMessage().getInt(REPEATER_C_STATE);
    }

    public String getRepeaterATimeslot0HashedAddress() {
        return String.format("%02X", this.getMessage().getInt(REPEATER_A_TS0_ADDRESS));
    }

    public String getRepeaterATimeslot1HashedAddress() {
        return String.format("%02X", this.getMessage().getInt(REPEATER_A_TS1_ADDRESS));
    }

    public String getRepeaterBTimeslot0HashedAddress() {
        return String.format("%02X", this.getMessage().getInt(REPEATER_B_TS0_ADDRESS));
    }

    public String getRepeaterBTimeslot1HashedAddress() {
        return String.format("%02X", this.getMessage().getInt(REPEATER_B_TS1_ADDRESS));
    }

    public String getRepeaterCTimeslot0HashedAddress() {
        return String.format("%02X", this.getMessage().getInt(REPEATER_C_TS0_ADDRESS));
    }

    public String getRepeaterCTimeslot1HashedAddress() {
        return String.format("%02X", this.getMessage().getInt(REPEATER_C_TS1_ADDRESS));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" HYTERA XPT SITE ");
        if (this.isAllChannelsBusy()) {
            sb.append(" ALL CHANNELS BUSY");
        } else {
            sb.append(" FREE:").append(this.getFreeRepeater());
        }
        sb.append(" STATE R").append(this.getRepeaterANumber()).append(":").append(this.getRepeaterAStateInfo());
        sb.append(" (").append(this.getRepeaterATimeslot0HashedAddress()).append("/");
        sb.append(this.getRepeaterATimeslot1HashedAddress()).append(")");
        sb.append(" R").append(this.getRepeaterBNumber()).append(":").append(this.getRepeaterBStateInfo());
        sb.append(" (").append(this.getRepeaterBTimeslot0HashedAddress()).append("/");
        sb.append(this.getRepeaterBTimeslot1HashedAddress()).append(")");
        sb.append(" R").append(this.getRepeaterCNumber()).append(":").append(this.getRepeaterCStateInfo());
        sb.append(" (").append(this.getRepeaterCTimeslot0HashedAddress()).append("/");
        sb.append(this.getRepeaterCTimeslot1HashedAddress()).append(")");
        return sb.toString();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
        }
        return this.mIdentifiers;
    }
}

