/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.hytera;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DmrTier3Radio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import java.util.ArrayList;
import java.util.List;

public class HyteraTrafficChannelTalkerStatus
extends CSBKMessage {
    private static final int[] UNKNOWN_1 = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] UNKNOWN_2 = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int TALKER_INACTIVE = 30;
    private static final int[] DESTINATION_RADIO = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] SOURCE_RADIO = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private List<Identifier> mIdentifiers;
    private RadioIdentifier mDestinationRadio;
    private RadioIdentifier mSourceRadio;

    public HyteraTrafficChannelTalkerStatus(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" HYTERA TRAFFIC CHANNEL");
        if (this.isChannelInactive()) {
            sb.append(" NOW AVAILABLE - PREVIOUS TALKER:").append(this.getDestinationRadio());
        } else {
            sb.append(" IN USE - CURRENT TALKER:").append(this.getDestinationRadio());
        }
        sb.append(" FM:").append(this.getSourceRadio());
        sb.append(" UNK1:").append(this.getUnknown1());
        sb.append(" UNK2:").append(this.getUnknown2());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public boolean isChannelInactive() {
        return this.getMessage().get(30);
    }

    public boolean isChannelActive() {
        return !this.isChannelInactive();
    }

    public RadioIdentifier getDestinationRadio() {
        if (this.mDestinationRadio == null) {
            this.mDestinationRadio = DmrTier3Radio.createTo(this.getMessage().getInt(DESTINATION_RADIO));
        }
        return this.mDestinationRadio;
    }

    public String getUnknown1() {
        return this.getMessage().getHex(UNKNOWN_1, 2);
    }

    public String getUnknown2() {
        return this.getMessage().getHex(UNKNOWN_2, 2);
    }

    public RadioIdentifier getSourceRadio() {
        if (this.mSourceRadio == null) {
            this.mSourceRadio = DmrTier3Radio.createFrom(this.getMessage().getInt(SOURCE_RADIO));
        }
        return this.mSourceRadio;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getDestinationRadio());
            this.mIdentifiers.add(this.getSourceRadio());
        }
        return this.mIdentifiers;
    }
}

