/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.Opcode;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.UnknownCSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.hytera.Hytera08Acknowledge;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.hytera.Hytera68Acknowledge;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.hytera.HyteraAdjacentSiteInformation;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.hytera.HyteraAloha;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.hytera.HyteraAnnouncement;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.hytera.HyteraCsbko44;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.hytera.HyteraSmsAvailableNotification;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.hytera.HyteraTrafficChannelTalkerStatus;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.hytera.HyteraXPTPreamble;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.hytera.HyteraXPTSiteState;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.CapacityMaxAloha;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.CapacityPlusCSBKO_60;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.CapacityPlusDataRevertWindowAnnouncement;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.CapacityPlusDataRevertWindowGrant;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.CapacityPlusNeighbors;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.CapacityPlusPreamble;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.CapacityPlusSiteStatus;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.ConnectPlusCSBKO_16;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.ConnectPlusDataChannelGrant;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.ConnectPlusDataRevertWindowAnnouncement;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.ConnectPlusDataRevertWindowGrant;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.ConnectPlusNeighborReport;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.ConnectPlusOTAAnnouncement;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.ConnectPlusRegistrationRequest;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.ConnectPlusRegistrationResponse;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.ConnectPlusTalkgroupAffiliation;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.ConnectPlusTerminateChannelGrant;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.ConnectPlusVoiceChannelUser;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.Aloha;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.Clear;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.MoveTSCC;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.Preamble;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.Protect;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.acknowledge.Acknowledge;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.acknowledge.AcknowledgeStatus;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.acknowledge.RegistrationAccepted;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.ahoy.Ahoy;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.ahoy.AuthenticateRegisterRadioCheck;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.ahoy.CancelCall;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.ahoy.ServiceRadioCheck;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.ahoy.StunReviveKill;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.ahoy.UnknownAhoy;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement.AdjacentSiteInformation;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement.AnnounceChannelFrequency;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement.AnnounceWithdrawTSCC;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement.Announcement;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement.CallTimerParameters;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement.LocalTime;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement.MassRegistration;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement.VoteNowAdvice;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.grant.BroadcastTalkgroupVoiceChannelGrant;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.grant.DuplexPrivateDataChannelGrant;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.grant.DuplexPrivateVoiceChannelGrant;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.grant.PrivateDataChannelGrant;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.grant.PrivateVoiceChannelGrant;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.grant.TalkgroupDataChannelGrant;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.grant.TalkgroupVoiceChannelGrant;
import io.github.dsheirer.module.decode.dmr.message.data.header.MBCHeader;
import io.github.dsheirer.module.decode.dmr.message.data.mbc.MBCContinuationBlock;
import io.github.dsheirer.module.decode.dmr.message.data.mbc.UnknownMultiCSBK;
import io.github.dsheirer.module.decode.dmr.message.type.AnnouncementType;
import io.github.dsheirer.module.decode.dmr.message.type.ServiceKind;
import java.util.List;

public class CSBKMessageFactory {
    public static CSBKMessage create(DMRSyncPattern pattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        CSBKMessage csbk = null;
        if (message != null) {
            Opcode opcode = CSBKMessage.getOpcode(message);
            block0 : switch (opcode) {
                case STANDARD_ACKNOWLEDGE_RESPONSE_INBOUND_TSCC: 
                case STANDARD_ACKNOWLEDGE_RESPONSE_OUTBOUND_TSCC: 
                case STANDARD_ACKNOWLEDGE_RESPONSE_INBOUND_PAYLOAD: 
                case STANDARD_ACKNOWLEDGE_RESPONSE_OUTBOUND_PAYLOAD: {
                    switch (Acknowledge.getReason(message)) {
                        case TS_REGISTRATION_ACCEPTED: {
                            csbk = new RegistrationAccepted(pattern, message, cach, slotType, timestamp, timeslot);
                            break block0;
                        }
                        case TS_ACCEPTED_FOR_STATUS_POLLING_SERVICE: {
                            csbk = new AcknowledgeStatus(pattern, message, cach, slotType, timestamp, timeslot);
                            break block0;
                        }
                    }
                    csbk = new Acknowledge(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case STANDARD_AHOY: {
                    ServiceKind serviceKind = Ahoy.getServiceKind(message);
                    switch (serviceKind) {
                        case AUTHENTICATE_REGISTER_RADIO_CHECK_SERVICE: {
                            csbk = new AuthenticateRegisterRadioCheck(pattern, message, cach, slotType, timestamp, timeslot);
                            break block0;
                        }
                        case CANCEL_CALL_SERVICE: {
                            csbk = new CancelCall(pattern, message, cach, slotType, timestamp, timeslot);
                            break block0;
                        }
                        case SUPPLEMENTARY_SERVICE: {
                            csbk = new StunReviveKill(pattern, message, cach, slotType, timestamp, timeslot);
                            break block0;
                        }
                        case FULL_DUPLEX_MS_TO_MS_PACKET_CALL_SERVICE: 
                        case FULL_DUPLEX_MS_TO_MS_VOICE_CALL_SERVICE: 
                        case INDIVIDUAL_VOICE_CALL_SERVICE: 
                        case INDIVIDUAL_PACKET_CALL_SERVICE: 
                        case INDIVIDUAL_UDT_SHORT_DATA_CALL_SERVICE: 
                        case TALKGROUP_PACKET_CALL_SERVICE: 
                        case TALKGROUP_UDT_SHORT_DATA_CALL_SERVICE: 
                        case TALKGROUP_VOICE_CALL_SERVICE: {
                            csbk = new ServiceRadioCheck(pattern, message, cach, slotType, timestamp, timeslot);
                            break block0;
                        }
                    }
                    csbk = new UnknownAhoy(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case STANDARD_ALOHA: {
                    csbk = new Aloha(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case STANDARD_ANNOUNCEMENT: {
                    switch (Announcement.getAnnouncementType(message)) {
                        case ADJACENT_SITE_INFORMATION: {
                            csbk = new AdjacentSiteInformation(pattern, message, cach, slotType, timestamp, timeslot);
                            break block0;
                        }
                        case ANNOUNCE_OR_WITHDRAW_TSCC: {
                            csbk = new AnnounceWithdrawTSCC(pattern, message, cach, slotType, timestamp, timeslot);
                            break block0;
                        }
                        case CALL_TIMER_PARAMETERS: {
                            csbk = new CallTimerParameters(pattern, message, cach, slotType, timestamp, timeslot);
                            break block0;
                        }
                        case LOCAL_TIME: {
                            csbk = new LocalTime(pattern, message, cach, slotType, timestamp, timeslot);
                            break block0;
                        }
                        case MASS_REGISTRATION: {
                            csbk = new MassRegistration(pattern, message, cach, slotType, timestamp, timeslot);
                            break block0;
                        }
                        case VOTE_NOW_ADVICE: {
                            csbk = new VoteNowAdvice(pattern, message, cach, slotType, timestamp, timeslot);
                            break block0;
                        }
                    }
                    csbk = new Announcement(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case STANDARD_BROADCAST_TALKGROUP_VOICE_CHANNEL_GRANT: {
                    csbk = new BroadcastTalkgroupVoiceChannelGrant(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case STANDARD_CLEAR: {
                    csbk = new Clear(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case STANDARD_DUPLEX_PRIVATE_DATA_CHANNEL_GRANT: {
                    csbk = new DuplexPrivateDataChannelGrant(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case STANDARD_DUPLEX_PRIVATE_VOICE_CHANNEL_GRANT: {
                    csbk = new DuplexPrivateVoiceChannelGrant(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case STANDARD_PRIVATE_DATA_CHANNEL_GRANT_SINGLE_ITEM: {
                    csbk = new PrivateDataChannelGrant(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case STANDARD_PRIVATE_VOICE_CHANNEL_GRANT: {
                    csbk = new PrivateVoiceChannelGrant(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case STANDARD_PROTECT: {
                    csbk = new Protect(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case STANDARD_TALKGROUP_DATA_CHANNEL_GRANT_SINGLE_ITEM: {
                    csbk = new TalkgroupDataChannelGrant(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case STANDARD_TALKGROUP_VOICE_CHANNEL_GRANT: {
                    csbk = new TalkgroupVoiceChannelGrant(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case STANDARD_MOVE_TSCC: {
                    csbk = new MoveTSCC(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case STANDARD_PREAMBLE: {
                    csbk = new Preamble(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case HYTERA_68_ALOHA: {
                    csbk = new HyteraAloha(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case HYTERA_08_ANNOUNCEMENT: 
                case HYTERA_68_ANNOUNCEMENT: {
                    AnnouncementType announcementType = HyteraAnnouncement.getAnnouncementType(message);
                    switch (announcementType) {
                        case ADJACENT_SITE_INFORMATION: {
                            csbk = new HyteraAdjacentSiteInformation(pattern, message, cach, slotType, timestamp, timeslot);
                            break block0;
                        }
                    }
                    csbk = new HyteraAnnouncement(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case HYTERA_68_XPT_PREAMBLE: {
                    csbk = new HyteraXPTPreamble(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case HYTERA_68_XPT_SITE_STATE: {
                    csbk = new HyteraXPTSiteState(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case HYTERA_08_ACKNOWLEDGE: {
                    csbk = new Hytera08Acknowledge(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case HYTERA_08_CSBKO_44: {
                    csbk = new HyteraCsbko44(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case HYTERA_08_TRAFFIC_CHANNEL_TALKER_STATUS: {
                    csbk = new HyteraTrafficChannelTalkerStatus(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case HYTERA_68_ACKNOWLEDGE: {
                    csbk = new Hytera68Acknowledge(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case HYTERA_68_CSBKO_62: {
                    csbk = new HyteraSmsAvailableNotification(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case MOTOROLA_CAPMAX_ALOHA: {
                    csbk = new CapacityMaxAloha(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case MOTOROLA_CAPPLUS_NEIGHBOR_REPORT: {
                    csbk = new CapacityPlusNeighbors(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case MOTOROLA_CAPPLUS_PREAMBLE: {
                    csbk = new CapacityPlusPreamble(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case MOTOROLA_CAPPLUS_SITE_STATUS: {
                    csbk = new CapacityPlusSiteStatus(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case MOTOROLA_CAPPLUS_DATA_WINDOW_ANNOUNCEMENT: {
                    csbk = new CapacityPlusDataRevertWindowAnnouncement(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case MOTOROLA_CAPPLUS_DATA_WINDOW_GRANT: {
                    csbk = new CapacityPlusDataRevertWindowGrant(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case MOTOROLA_CONPLUS_CSBKO_10: {
                    csbk = new ConnectPlusOTAAnnouncement(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case MOTOROLA_CONPLUS_CSBKO_16: {
                    csbk = new ConnectPlusCSBKO_16(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case MOTOROLA_CONPLUS_REGISTRATION_REQUEST: {
                    csbk = new ConnectPlusRegistrationRequest(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case MOTOROLA_CONPLUS_REGISTRATION_RESPONSE: {
                    csbk = new ConnectPlusRegistrationResponse(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case MOTOROLA_CONPLUS_TALKGROUP_AFFILIATION: {
                    csbk = new ConnectPlusTalkgroupAffiliation(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case MOTOROLA_CAPPLUS_CSBKO_60: {
                    csbk = new CapacityPlusCSBKO_60(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case MOTOROLA_CONPLUS_DATA_CHANNEL_GRANT: {
                    csbk = new ConnectPlusDataChannelGrant(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case MOTOROLA_CONPLUS_NEIGHBOR_REPORT: {
                    csbk = new ConnectPlusNeighborReport(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case MOTOROLA_CONPLUS_TERMINATE_CHANNEL_GRANT: {
                    csbk = new ConnectPlusTerminateChannelGrant(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case MOTOROLA_CONPLUS_VOICE_CHANNEL_USER: {
                    csbk = new ConnectPlusVoiceChannelUser(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case MOTOROLA_CONPLUS_DATA_WINDOW_ANNOUNCEMENT: {
                    csbk = new ConnectPlusDataRevertWindowAnnouncement(pattern, message, cach, slotType, timestamp, timeslot);
                    break;
                }
                case MOTOROLA_CONPLUS_DATA_WINDOW_GRANT: {
                    csbk = new ConnectPlusDataRevertWindowGrant(pattern, message, cach, slotType, timestamp, timeslot);
                }
            }
            if (csbk == null) {
                csbk = new UnknownCSBKMessage(pattern, message, cach, slotType, timestamp, timeslot);
            }
        }
        if (csbk != null) {
            csbk.checkCRC();
        }
        return csbk;
    }

    public static CSBKMessage create(MBCHeader header, List<MBCContinuationBlock> continuationBlocks) {
        Opcode opcode = header.getOpcode();
        CSBKMessage csbk = switch (opcode) {
            case Opcode.STANDARD_ANNOUNCEMENT -> {
                AnnouncementType announcementType = Announcement.getAnnouncementType(header.getMessage());
                switch (announcementType) {
                    case ADJACENT_SITE_INFORMATION: {
                        yield new AdjacentSiteInformation(header.getSyncPattern(), header.getMessage(), header.getCACH(), header.getSlotType(), header.getTimestamp(), header.getTimeslot(), CSBKMessageFactory.getBlock1(continuationBlocks));
                    }
                    case ANNOUNCE_OR_WITHDRAW_TSCC: {
                        yield new AnnounceWithdrawTSCC(header.getSyncPattern(), header.getMessage(), header.getCACH(), header.getSlotType(), header.getTimestamp(), header.getTimeslot(), CSBKMessageFactory.getBlock1(continuationBlocks));
                    }
                    case CHANNEL_FREQUENCY_ANNOUNCEMENT: {
                        yield new AnnounceChannelFrequency(header.getSyncPattern(), header.getMessage(), header.getCACH(), header.getSlotType(), header.getTimestamp(), header.getTimeslot(), CSBKMessageFactory.getBlock1(continuationBlocks));
                    }
                    case VOTE_NOW_ADVICE: {
                        yield new VoteNowAdvice(header.getSyncPattern(), header.getMessage(), header.getCACH(), header.getSlotType(), header.getTimestamp(), header.getTimeslot(), CSBKMessageFactory.getBlock1(continuationBlocks));
                    }
                }
                yield new UnknownMultiCSBK(header, continuationBlocks);
            }
            case Opcode.STANDARD_BROADCAST_TALKGROUP_VOICE_CHANNEL_GRANT -> new BroadcastTalkgroupVoiceChannelGrant(header.getSyncPattern(), header.getMessage(), header.getCACH(), header.getSlotType(), header.getTimestamp(), header.getTimeslot(), CSBKMessageFactory.getBlock1(continuationBlocks));
            case Opcode.STANDARD_CLEAR -> new Clear(header.getSyncPattern(), header.getMessage(), header.getCACH(), header.getSlotType(), header.getTimestamp(), header.getTimeslot(), CSBKMessageFactory.getBlock1(continuationBlocks));
            case Opcode.STANDARD_DUPLEX_PRIVATE_DATA_CHANNEL_GRANT -> new DuplexPrivateDataChannelGrant(header.getSyncPattern(), header.getMessage(), header.getCACH(), header.getSlotType(), header.getTimestamp(), header.getTimeslot(), CSBKMessageFactory.getBlock1(continuationBlocks));
            case Opcode.STANDARD_DUPLEX_PRIVATE_VOICE_CHANNEL_GRANT -> new DuplexPrivateVoiceChannelGrant(header.getSyncPattern(), header.getMessage(), header.getCACH(), header.getSlotType(), header.getTimestamp(), header.getTimeslot(), CSBKMessageFactory.getBlock1(continuationBlocks));
            case Opcode.STANDARD_MOVE_TSCC -> new MoveTSCC(header.getSyncPattern(), header.getMessage(), header.getCACH(), header.getSlotType(), header.getTimestamp(), header.getTimeslot(), CSBKMessageFactory.getBlock1(continuationBlocks));
            case Opcode.STANDARD_PRIVATE_DATA_CHANNEL_GRANT_SINGLE_ITEM -> new PrivateDataChannelGrant(header.getSyncPattern(), header.getMessage(), header.getCACH(), header.getSlotType(), header.getTimestamp(), header.getTimeslot(), CSBKMessageFactory.getBlock1(continuationBlocks));
            case Opcode.STANDARD_PRIVATE_VOICE_CHANNEL_GRANT -> new PrivateVoiceChannelGrant(header.getSyncPattern(), header.getMessage(), header.getCACH(), header.getSlotType(), header.getTimestamp(), header.getTimeslot(), CSBKMessageFactory.getBlock1(continuationBlocks));
            case Opcode.STANDARD_TALKGROUP_DATA_CHANNEL_GRANT_SINGLE_ITEM -> new TalkgroupDataChannelGrant(header.getSyncPattern(), header.getMessage(), header.getCACH(), header.getSlotType(), header.getTimestamp(), header.getTimeslot(), CSBKMessageFactory.getBlock1(continuationBlocks));
            case Opcode.STANDARD_TALKGROUP_VOICE_CHANNEL_GRANT -> new TalkgroupVoiceChannelGrant(header.getSyncPattern(), header.getMessage(), header.getCACH(), header.getSlotType(), header.getTimestamp(), header.getTimeslot(), CSBKMessageFactory.getBlock1(continuationBlocks));
            case Opcode.HYTERA_08_ANNOUNCEMENT, Opcode.HYTERA_68_ANNOUNCEMENT -> {
                AnnouncementType hyteraAnnouncementType = HyteraAnnouncement.getAnnouncementType(header.getMessage());
                switch (hyteraAnnouncementType) {
                    case ADJACENT_SITE_INFORMATION: {
                        yield new HyteraAdjacentSiteInformation(header.getSyncPattern(), header.getMessage(), header.getCACH(), header.getSlotType(), header.getTimestamp(), header.getTimeslot(), CSBKMessageFactory.getBlock1(continuationBlocks));
                    }
                }
                yield new UnknownMultiCSBK(header, continuationBlocks);
            }
            default -> new UnknownMultiCSBK(header, continuationBlocks);
        };
        if (csbk != null) {
            csbk.checkCRC();
        }
        return csbk;
    }

    private static MBCContinuationBlock getBlock1(List<MBCContinuationBlock> blocks) {
        if (blocks != null && blocks.size() >= 1) {
            return blocks.get(0);
        }
        return null;
    }
}

