/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRCDMR;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.DataMessage;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.Opcode;
import io.github.dsheirer.module.decode.dmr.message.type.AbsoluteChannelParameters;
import io.github.dsheirer.module.decode.dmr.message.type.Vendor;

public abstract class CSBKMessage
extends DataMessage {
    protected static final int CSBK_CRC_MASK = 42405;
    protected static final int MBC_HEADER_CRC_MASK = 43690;
    protected static final int MBC_LAST_BLOCK_CRC_MASK = 0;
    private static final int LAST_BLOCK = 0;
    private static final int PROTECT_FLAG = 1;
    private static final int[] OPCODE = new int[]{2, 3, 4, 5, 6, 7};
    private static final int[] VENDOR = new int[]{8, 9, 10, 11, 12, 13, 14, 15};

    public CSBKMessage(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    public void checkCRC() {
        int correctedBitCount = CRCDMR.correctCCITT80(this.getMessage(), 0, 80, 42405);
        this.setValid(correctedBitCount < 2);
    }

    public void checkCRC(int mask) {
        int correctedBitCount = CRCDMR.correctCCITT80(this.getMessage(), 0, 80, mask);
        this.setValid(correctedBitCount < 2);
    }

    protected void checkMultiBlockCRC(AbsoluteChannelParameters absoluteChannelParameters) {
        int headerCorrectedBitCount = CRCDMR.correctCCITT80(this.getMessage(), 0, 80, 43690);
        int continuationCorrectedBitCount = 0;
        if (absoluteChannelParameters != null) {
            continuationCorrectedBitCount = CRCDMR.correctCCITT80(absoluteChannelParameters.getMessage(), 0, 80, 0);
        }
        this.setValid(headerCorrectedBitCount < 2 && continuationCorrectedBitCount < 2);
    }

    public boolean isLastBlock() {
        return this.getMessage().get(0);
    }

    public boolean isEncrypted() {
        return this.getMessage().get(1);
    }

    public static Opcode getOpcode(BinaryMessage message) {
        return Opcode.fromValue(message.getInt(OPCODE), CSBKMessage.getVendor(message));
    }

    public Opcode getOpcode() {
        return CSBKMessage.getOpcode(this.getMessage());
    }

    protected int getOpcodeValue() {
        return this.getMessage().getInt(OPCODE);
    }

    public static Vendor getVendor(BinaryMessage message) {
        return Vendor.fromValue(message.getInt(VENDOR));
    }

    public Vendor getVendor() {
        return CSBKMessage.getVendor(this.getMessage());
    }

    protected int getVendorID() {
        return this.getMessage().getInt(VENDOR);
    }
}

