/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.Golay24;
import io.github.dsheirer.module.decode.dmr.message.type.DataType;

public class SlotType {
    private static final int[] MESSAGE_INDEXES = new int[]{122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189};
    private static final int[] COLOR_CODE = new int[]{4, 5, 6, 7};
    private static final int[] DATA_TYPE = new int[]{8, 9, 10, 11};
    private CorrectedBinaryMessage mMessage;
    private boolean mValid;

    public SlotType(CorrectedBinaryMessage message) {
        this.mMessage = message;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CC:").append(this.getColorCode());
        sb.append(" ").append((Object)this.getDataType());
        return sb.toString();
    }

    private CorrectedBinaryMessage getMessage() {
        return this.mMessage;
    }

    void setValid(boolean valid) {
        this.mValid = valid;
    }

    public boolean isValid() {
        return this.mValid;
    }

    public static SlotType getSlotType(BinaryMessage message) {
        CorrectedBinaryMessage decodedMessage = new CorrectedBinaryMessage(24);
        for (int x = 0; x < MESSAGE_INDEXES.length; ++x) {
            if (!message.get(MESSAGE_INDEXES[x])) continue;
            decodedMessage.set(x + 4);
        }
        int errorCount = Golay24.checkAndCorrect(decodedMessage, 0);
        decodedMessage.setCorrectedBitCount(errorCount);
        SlotType slotType = new SlotType(decodedMessage);
        slotType.setValid(errorCount < 3);
        return slotType;
    }

    public int getColorCode() {
        return this.getMessage().getInt(COLOR_CODE);
    }

    public DataType getDataType() {
        return DataType.fromValue(this.getMessage().getInt(DATA_TYPE));
    }
}

