/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.DMRBurst;
import io.github.dsheirer.module.decode.dmr.message.UnknownDMRMessage;
import io.github.dsheirer.module.decode.dmr.message.data.DMRDataMessageFactory;
import io.github.dsheirer.module.decode.dmr.message.voice.VoiceAMessage;
import io.github.dsheirer.module.decode.dmr.message.voice.VoiceEMBMessage;
import io.github.dsheirer.module.decode.dmr.message.voice.VoiceMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMRMessageFactory {
    private static final Logger mLog = LoggerFactory.getLogger(DMRMessageFactory.class);

    public static DMRBurst create(DMRSyncPattern syncPattern, CorrectedBinaryMessage binaryMessage, CACH cach, long timestamp, int timeslot) {
        switch (syncPattern) {
            case BASE_STATION_VOICE: 
            case MOBILE_STATION_VOICE: 
            case BS_VOICE_FRAME_B: 
            case BS_VOICE_FRAME_C: 
            case BS_VOICE_FRAME_D: 
            case BS_VOICE_FRAME_E: 
            case BS_VOICE_FRAME_F: 
            case MS_VOICE_FRAME_B: 
            case MS_VOICE_FRAME_C: 
            case MS_VOICE_FRAME_D: 
            case MS_VOICE_FRAME_E: 
            case MS_VOICE_FRAME_F: {
                return DMRMessageFactory.createVoiceMessage(syncPattern, binaryMessage, cach, timestamp, timeslot);
            }
            case DIRECT_MODE_VOICE_TIMESLOT_1: {
                return DMRMessageFactory.createVoiceMessage(syncPattern, binaryMessage, cach, timestamp, 1);
            }
            case DIRECT_MODE_VOICE_TIMESLOT_2: {
                return DMRMessageFactory.createVoiceMessage(syncPattern, binaryMessage, cach, timestamp, 2);
            }
            case BASE_STATION_DATA: 
            case MOBILE_STATION_DATA: {
                return DMRDataMessageFactory.create(syncPattern, binaryMessage, cach, timestamp, timeslot);
            }
            case DIRECT_MODE_DATA_TIMESLOT_1: {
                return DMRDataMessageFactory.create(syncPattern, binaryMessage, cach, timestamp, 1);
            }
            case DIRECT_MODE_DATA_TIMESLOT_2: {
                return DMRDataMessageFactory.create(syncPattern, binaryMessage, cach, timestamp, 2);
            }
            case UNKNOWN: {
                return null;
            }
        }
        return new UnknownDMRMessage(syncPattern, binaryMessage, cach, timestamp, timeslot);
    }

    private static VoiceMessage createVoiceMessage(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, long timestamp, int timeslot) {
        switch (syncPattern) {
            case BASE_STATION_VOICE: 
            case MOBILE_STATION_VOICE: 
            case DIRECT_MODE_VOICE_TIMESLOT_1: 
            case DIRECT_MODE_VOICE_TIMESLOT_2: {
                return new VoiceAMessage(syncPattern, message, cach, timestamp, timeslot);
            }
        }
        return new VoiceEMBMessage(syncPattern, message, cach, timestamp, timeslot);
    }
}

