/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.message.type.LCSS;

public class CACH {
    private static final int CACH_MESSAGE_LENGTH = 24;
    private static final int[] INTERLEAVE_MATRIX = new int[]{0, 4, 8, 12, 14, 18, 22, 1, 2, 3, 5, 6, 7, 9, 10, 11, 13, 15, 16, 17, 19, 20, 21, 23};
    private static final int INBOUND_CHANNEL_ACCESS_TYPE = 0;
    private static final int OUTBOUND_BURST_TIMESLOT = 1;
    private static final int[] LINK_CONTROL_START_STOP = new int[]{2, 3};
    private static final int[] CACH_CRC = new int[]{4, 5, 6};
    private static final int[] CHECKSUMS = new int[]{5, 7, 6, 3};
    private static final int PAYLOAD_START = 7;
    private static final int PAYLOAD_END = 24;
    private CorrectedBinaryMessage mMessage;
    private boolean mValid;

    public CACH(CorrectedBinaryMessage message, boolean valid) {
        this.mMessage = message;
        this.mValid = valid;
    }

    public CorrectedBinaryMessage getMessage() {
        return this.mMessage;
    }

    public boolean hasHyteraCachScrambling() {
        if (!this.isValid()) {
            BinaryMessage copy = this.getMessage().copy();
            copy.flip(0);
            if (CACH.getCrcChecksum(copy) == 0) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getLCSS());
        return sb.toString();
    }

    public boolean isValid() {
        return this.mValid;
    }

    public AccessType getInboundChannelAccessType() {
        if (this.mMessage.get(0)) {
            return AccessType.BUSY;
        }
        return AccessType.IDLE;
    }

    public LCSS getLCSS() {
        return LCSS.fromValue(this.mMessage.getInt(LINK_CONTROL_START_STOP));
    }

    public int getTimeslot() {
        return this.mMessage.get(1) ? 1 : 0;
    }

    public boolean isTimeslot0() {
        return !this.mMessage.get(1);
    }

    public BinaryMessage getPayload() {
        return this.mMessage.getSubMessage(7, 24);
    }

    public static CACH getCACH(CorrectedBinaryMessage message) {
        CorrectedBinaryMessage decodedMessage = new CorrectedBinaryMessage(24);
        for (int x = 0; x < 24; ++x) {
            if (!message.get(INTERLEAVE_MATRIX[x])) continue;
            decodedMessage.set(x);
        }
        int checksum = CACH.getCrcChecksum(decodedMessage);
        boolean valid = checksum == 0;
        return new CACH(decodedMessage, valid);
    }

    public static int getCrcChecksum(BinaryMessage message) {
        int checksum = message.getInt(CACH_CRC);
        for (int x = 0; x < 4; ++x) {
            if (!message.get(x)) continue;
            checksum ^= CHECKSUMS[x];
        }
        return checksum;
    }

    public static enum AccessType {
        IDLE,
        BUSY;

    }
}

