/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.event;

import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.module.decode.dmr.channel.DMRChannel;
import io.github.dsheirer.module.decode.dmr.event.DMRDecodeEvent;
import io.github.dsheirer.module.decode.event.DecodeEventType;

public class DMRChannelGrantEvent
extends DMRDecodeEvent {
    private boolean mEncrypted;

    public DMRChannelGrantEvent(DecodeEventType decodeEventType, long timestamp) {
        super(decodeEventType, timestamp);
    }

    public boolean isEncrypted() {
        return this.mEncrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.mEncrypted = encrypted;
    }

    public static DMRChannelGrantDecodeEventBuilder channelGrantBuilder(DecodeEventType decodeEventType, long timeStart) {
        return new DMRChannelGrantDecodeEventBuilder(decodeEventType, timeStart);
    }

    public static class DMRChannelGrantDecodeEventBuilder {
        protected long mTimeStart;
        protected long mDuration;
        protected DecodeEventType mDecodeEventType;
        protected IdentifierCollection mIdentifierCollection;
        protected DMRChannel mChannel;
        protected String mDetails;
        protected boolean mEncrypted;

        public DMRChannelGrantDecodeEventBuilder(DecodeEventType decodeEventType, long timeStart) {
            this.mDecodeEventType = decodeEventType;
            this.mTimeStart = timeStart;
        }

        public DMRChannelGrantDecodeEventBuilder encrypted(boolean encrypted) {
            this.mEncrypted = encrypted;
            return this;
        }

        public DMRChannelGrantDecodeEventBuilder duration(long duration) {
            this.mDuration = duration;
            return this;
        }

        public DMRChannelGrantDecodeEventBuilder end(long timestamp) {
            this.mDuration = timestamp - this.mTimeStart;
            return this;
        }

        public DMRChannelGrantDecodeEventBuilder channel(DMRChannel channel) {
            this.mChannel = channel;
            return this;
        }

        public DMRChannelGrantDecodeEventBuilder identifiers(IdentifierCollection identifierCollection) {
            this.mIdentifierCollection = identifierCollection;
            return this;
        }

        public DMRChannelGrantDecodeEventBuilder details(String details) {
            this.mDetails = details;
            return this;
        }

        public DMRChannelGrantEvent build() {
            DMRChannelGrantEvent decodeEvent = new DMRChannelGrantEvent(this.mDecodeEventType, this.mTimeStart);
            decodeEvent.setChannelDescriptor(this.mChannel);
            decodeEvent.setTimeslot(this.mChannel.getTimeslot());
            decodeEvent.setDetails(this.mDetails);
            decodeEvent.setDuration(this.mDuration);
            decodeEvent.setIdentifierCollection(this.mIdentifierCollection);
            return decodeEvent;
        }
    }
}

