/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.channel;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.util.Callback;

public class TimeslotFrequency {
    private IntegerProperty mNumberProperty = new SimpleIntegerProperty();
    private LongProperty mDownlinkFrequencyProperty = new SimpleLongProperty();
    private LongProperty mUplinkFrequencyProperty = new SimpleLongProperty();
    private DoubleProperty mDownlinkMhzProperty = new SimpleDoubleProperty();
    private DoubleProperty mUplinkMhzProperty = new SimpleDoubleProperty();

    public TimeslotFrequency copy() {
        TimeslotFrequency copy = new TimeslotFrequency();
        copy.setNumber(this.getNumber());
        copy.setDownlinkFrequency(this.getDownlinkFrequency());
        copy.setUplinkFrequency(this.getUplinkFrequency());
        return copy;
    }

    @JsonIgnore
    public IntegerProperty getNumberProperty() {
        return this.mNumberProperty;
    }

    @JsonIgnore
    public LongProperty downlinkFrequencyProperty() {
        return this.mDownlinkFrequencyProperty;
    }

    @JsonIgnore
    public LongProperty uplinkFrequencyProperty() {
        return this.mUplinkFrequencyProperty;
    }

    @JsonIgnore
    public DoubleProperty getDownlinkMHz() {
        return this.mDownlinkMhzProperty;
    }

    @JsonIgnore
    public DoubleProperty getUplinkMHz() {
        return this.mUplinkMhzProperty;
    }

    @JacksonXmlProperty(isAttribute=true, localName="lsn")
    public int getNumber() {
        return this.mNumberProperty.get();
    }

    @JsonIgnore
    public int getChannelNumber() {
        return this.getNumber();
    }

    @JsonIgnore
    public String getLogicalSlotNumbers() {
        StringBuilder sb = new StringBuilder();
        int channel = this.getChannelNumber();
        if (channel > 0) {
            if (channel < 32) {
                int lsn1 = (channel - 1) * 2 + 1;
                int lsn2 = (channel - 1) * 2 + 2;
                sb.append("LSN:").append(lsn1).append("/").append(lsn2).append(" or ");
            }
            int chanId1 = channel * 2 + 1;
            int chanId2 = channel * 2 + 2;
            sb.append("Tier3 Chan:").append(chanId1).append("/").append(chanId2);
        } else {
            sb.append("(empty)");
        }
        return sb.toString();
    }

    public void setNumber(int lcn) {
        this.mNumberProperty.set(lcn);
    }

    @JacksonXmlProperty(isAttribute=true, localName="downlink")
    public long getDownlinkFrequency() {
        return this.mDownlinkFrequencyProperty.get();
    }

    public void setDownlinkFrequency(long downlinkFrequency) {
        this.mDownlinkFrequencyProperty.set(downlinkFrequency);
        this.getDownlinkMHz().set((double)downlinkFrequency / 1000000.0);
    }

    @JacksonXmlProperty(isAttribute=true, localName="uplink")
    public long getUplinkFrequency() {
        return this.mUplinkFrequencyProperty.get();
    }

    public void setUplinkFrequency(long uplinkFrequency) {
        this.mUplinkFrequencyProperty.set(uplinkFrequency);
        this.getUplinkMHz().set((double)uplinkFrequency / 1000000.0);
    }

    public String toString() {
        return "LCN:" + this.getNumber() + " DOWNLINK:" + this.getDownlinkFrequency();
    }

    /*
     * Exception decompiling
     */
    public static Callback<TimeslotFrequency, Observable[]> extractor() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

