/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.audio;

import io.github.dsheirer.audio.codec.mbe.MBECallSequence;
import io.github.dsheirer.audio.codec.mbe.MBECallSequenceRecorder;
import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.dmr.message.DMRMessage;
import io.github.dsheirer.module.decode.dmr.message.data.header.VoiceHeader;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCMessage;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.FullLCMessage;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.GroupVoiceChannelUser;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.UnitToUnitVoiceChannelUser;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.hytera.HyteraGroupVoiceChannelUser;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.hytera.HyteraUnitToUnitVoiceChannelUser;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.motorola.CapacityPlusWideAreaVoiceChannelUser;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.motorola.MotorolaGroupVoiceChannelUser;
import io.github.dsheirer.module.decode.dmr.message.data.terminator.Terminator;
import io.github.dsheirer.module.decode.dmr.message.voice.VoiceMessage;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.sample.Listener;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMRCallSequenceRecorder
extends MBECallSequenceRecorder {
    private static final Logger mLog = LoggerFactory.getLogger(DMRCallSequenceRecorder.class);
    private static final String PROTOCOL = "DMR";
    private TimeslotProcessor mTimeslotProcessor1 = new TimeslotProcessor();
    private TimeslotProcessor mTimeslotProcessor2 = new TimeslotProcessor();

    public DMRCallSequenceRecorder(UserPreferences userPreferences, long channelFrequency, String system, String site) {
        super(userPreferences, channelFrequency, system, site);
    }

    @Override
    public void stop() {
        this.mTimeslotProcessor1.flush();
        this.mTimeslotProcessor2.flush();
    }

    @Override
    public void receive(IMessage message) {
        DMRMessage dmr;
        if (message instanceof DMRMessage && (dmr = (DMRMessage)message).isValid()) {
            switch (dmr.getTimeslot()) {
                case 1: {
                    this.mTimeslotProcessor1.receive(dmr);
                    break;
                }
                case 2: {
                    this.mTimeslotProcessor2.receive(dmr);
                }
            }
        }
    }

    private class TimeslotProcessor
    implements Listener<DMRMessage> {
        private MBECallSequence mCallSequence;
        private Identifier mFromIdentifier;
        private Identifier mToIdentifier;
        private String mCallType;
        private boolean mEncrypted = false;

        private TimeslotProcessor() {
        }

        public void flush() {
            if (this.mCallSequence != null) {
                DMRCallSequenceRecorder.this.writeCallSequence(this.mCallSequence);
            }
            this.mCallSequence = null;
            this.mToIdentifier = null;
            this.mFromIdentifier = null;
            this.mCallType = null;
            this.mEncrypted = false;
        }

        @Override
        public void receive(DMRMessage message) {
            if (message instanceof VoiceMessage) {
                VoiceMessage voiceMessage = (VoiceMessage)message;
                this.process(voiceMessage);
            } else if (message instanceof VoiceHeader) {
                VoiceHeader voiceHeader = (VoiceHeader)message;
                this.process(voiceHeader);
            } else if (message instanceof FullLCMessage) {
                FullLCMessage fullLCMessage = (FullLCMessage)message;
                this.process(fullLCMessage);
            } else if (message instanceof Terminator) {
                LCMessage lCMessage;
                Terminator terminator = (Terminator)message;
                if (this.mCallSequence != null && (lCMessage = terminator.getLCMessage()) instanceof FullLCMessage) {
                    FullLCMessage flc = (FullLCMessage)lCMessage;
                    this.process(flc);
                }
                this.flush();
            }
        }

        private void process(VoiceHeader voiceHeader) {
            LCMessage lCMessage = voiceHeader.getLCMessage();
            if (lCMessage instanceof FullLCMessage) {
                FullLCMessage flc = (FullLCMessage)lCMessage;
                this.process(flc);
            }
        }

        private void process(VoiceMessage voiceMessage) {
            if (this.mCallSequence == null) {
                this.mCallSequence = new MBECallSequence(DMRCallSequenceRecorder.PROTOCOL);
                this.mCallSequence.setFromIdentifier(this.mFromIdentifier);
                this.mCallSequence.setToIdentifier(this.mToIdentifier);
                this.mCallSequence.setCallType(this.mCallType);
                this.mCallSequence.setEncrypted(this.mEncrypted);
            }
            List<byte[]> voiceFrames = voiceMessage.getAMBEFrames();
            long baseTimestamp = voiceMessage.getTimestamp();
            for (byte[] frame : voiceFrames) {
                BinaryMessage frameBits = BinaryMessage.from(frame);
                this.mCallSequence.addVoiceFrame(baseTimestamp, frameBits.toHexString());
                baseTimestamp += 20L;
            }
        }

        private void process(FullLCMessage message) {
            if (message.isValid()) {
                switch (message.getOpcode()) {
                    case FULL_MOTOROLA_GROUP_VOICE_CHANNEL_USER: {
                        if (!(message instanceof MotorolaGroupVoiceChannelUser)) break;
                        MotorolaGroupVoiceChannelUser cpvcu = (MotorolaGroupVoiceChannelUser)message;
                        if (this.mCallSequence == null) {
                            this.mFromIdentifier = cpvcu.getRadio();
                            this.mToIdentifier = cpvcu.getTalkgroup();
                            this.mEncrypted = cpvcu.getServiceOptions().isEncrypted();
                            this.mCallType = "GROUP";
                            break;
                        }
                        this.mCallSequence.setFromIdentifier(cpvcu.getRadio());
                        this.mCallSequence.setToIdentifier(cpvcu.getTalkgroup());
                        this.mCallSequence.setEncrypted(cpvcu.getServiceOptions().isEncrypted());
                        this.mCallSequence.setCallType("GROUP");
                        break;
                    }
                    case FULL_CAPACITY_PLUS_WIDE_AREA_VOICE_CHANNEL_USER: {
                        if (!(message instanceof CapacityPlusWideAreaVoiceChannelUser)) break;
                        CapacityPlusWideAreaVoiceChannelUser cpwavcu = (CapacityPlusWideAreaVoiceChannelUser)message;
                        if (this.mCallSequence == null) {
                            this.mToIdentifier = cpwavcu.getTalkgroup();
                            this.mEncrypted = cpwavcu.getServiceOptions().isEncrypted();
                            this.mCallType = "GROUP";
                            break;
                        }
                        this.mCallSequence.setToIdentifier(cpwavcu.getTalkgroup());
                        this.mCallSequence.setEncrypted(cpwavcu.getServiceOptions().isEncrypted());
                        this.mCallSequence.setCallType("GROUP");
                        break;
                    }
                    case FULL_HYTERA_GROUP_VOICE_CHANNEL_USER: {
                        if (!(message instanceof HyteraGroupVoiceChannelUser)) break;
                        HyteraGroupVoiceChannelUser hgvcu = (HyteraGroupVoiceChannelUser)message;
                        if (this.mCallSequence == null) {
                            this.mToIdentifier = hgvcu.getTalkgroup();
                            this.mFromIdentifier = hgvcu.getSourceRadio();
                            this.mCallType = "GROUP";
                            this.mEncrypted = hgvcu.isEncrypted();
                            break;
                        }
                        this.mCallSequence.setToIdentifier(hgvcu.getTalkgroup());
                        this.mCallSequence.setFromIdentifier(hgvcu.getSourceRadio());
                        this.mCallSequence.setCallType("GROUP");
                        this.mCallSequence.setEncrypted(hgvcu.isEncrypted());
                        break;
                    }
                    case FULL_HYTERA_UNIT_TO_UNIT_VOICE_CHANNEL_USER: {
                        if (!(message instanceof HyteraUnitToUnitVoiceChannelUser)) break;
                        HyteraUnitToUnitVoiceChannelUser huuvcu = (HyteraUnitToUnitVoiceChannelUser)message;
                        if (this.mCallSequence == null) {
                            this.mToIdentifier = huuvcu.getTargetRadio();
                            this.mFromIdentifier = huuvcu.getSourceRadio();
                            this.mCallType = "INDIVIDUAL";
                            this.mEncrypted = huuvcu.isEncrypted();
                            break;
                        }
                        this.mCallSequence.setToIdentifier(huuvcu.getTargetRadio());
                        this.mCallSequence.setFromIdentifier(huuvcu.getSourceRadio());
                        this.mCallSequence.setCallType("INDIVIDUAL");
                        this.mCallSequence.setEncrypted(huuvcu.isEncrypted());
                        break;
                    }
                    case FULL_STANDARD_GROUP_VOICE_CHANNEL_USER: {
                        if (!(message instanceof GroupVoiceChannelUser)) break;
                        GroupVoiceChannelUser gvcu = (GroupVoiceChannelUser)message;
                        if (this.mCallSequence == null) {
                            this.mFromIdentifier = gvcu.getRadio();
                            this.mToIdentifier = gvcu.getTalkgroup();
                            this.mCallType = "GROUP";
                            this.mEncrypted = gvcu.getServiceOptions().isEncrypted();
                            break;
                        }
                        this.mCallSequence.setFromIdentifier(gvcu.getRadio());
                        this.mCallSequence.setToIdentifier(gvcu.getTalkgroup());
                        this.mCallSequence.setCallType("GROUP");
                        this.mCallSequence.setEncrypted(gvcu.getServiceOptions().isEncrypted());
                        break;
                    }
                    case FULL_STANDARD_UNIT_TO_UNIT_VOICE_CHANNEL_USER: {
                        if (!(message instanceof UnitToUnitVoiceChannelUser)) break;
                        UnitToUnitVoiceChannelUser uuvcu = (UnitToUnitVoiceChannelUser)message;
                        if (this.mCallSequence == null) {
                            this.mFromIdentifier = uuvcu.getSourceRadio();
                            this.mToIdentifier = uuvcu.getTargetRadio();
                            this.mCallType = "INDIVIDUAL";
                            this.mEncrypted = uuvcu.getServiceOptions().isEncrypted();
                            break;
                        }
                        this.mCallSequence.setFromIdentifier(uuvcu.getSourceRadio());
                        this.mCallSequence.setToIdentifier(uuvcu.getTargetRadio());
                        this.mCallSequence.setCallType("INDIVIDUAL");
                        this.mCallSequence.setEncrypted(uuvcu.getServiceOptions().isEncrypted());
                    }
                }
            }
        }
    }
}

