/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.config.DecodeConfiguration;
import io.github.dsheirer.module.decode.dmr.channel.TimeslotFrequency;
import io.github.dsheirer.source.tuner.channel.ChannelSpecification;
import java.util.ArrayList;
import java.util.List;

public class DecodeConfigDMR
extends DecodeConfiguration {
    public static final int CHANNEL_ROTATION_DELAY_MINIMUM_MS = 200;
    public static final int CHANNEL_ROTATION_DELAY_DEFAULT_MS = 500;
    public static final int CHANNEL_ROTATION_DELAY_MAXIMUM_MS = 2000;
    private int mTrafficChannelPoolSize = 3;
    private boolean mIgnoreDataCalls = true;
    private boolean mIgnoreCRCChecksums = false;
    private boolean mUseCompressedTalkgroups = false;
    private List<TimeslotFrequency> mTimeslotMap = new ArrayList<TimeslotFrequency>();

    @Override
    public int getTimeslotCount() {
        return 2;
    }

    @Override
    public int[] getTimeslots() {
        int[] timeslots = new int[]{1, 2};
        return timeslots;
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public DecoderType getDecoderType() {
        return DecoderType.DMR;
    }

    @JacksonXmlProperty(isAttribute=true, localName="ignore_data_calls")
    public boolean getIgnoreDataCalls() {
        return this.mIgnoreDataCalls;
    }

    public void setIgnoreDataCalls(boolean ignore) {
        this.mIgnoreDataCalls = ignore;
    }

    @JacksonXmlProperty(isAttribute=true, localName="ignore_crc")
    public boolean getIgnoreCRCChecksums() {
        return this.mIgnoreCRCChecksums;
    }

    public void setIgnoreCRCChecksums(boolean ignore) {
        this.mIgnoreCRCChecksums = ignore;
    }

    @JacksonXmlProperty(isAttribute=true, localName="use_compressed_talkgroups")
    public boolean isUseCompressedTalkgroups() {
        return this.mUseCompressedTalkgroups;
    }

    public void setUseCompressedTalkgroups(boolean useCompressedTalkgroups) {
        this.mUseCompressedTalkgroups = useCompressedTalkgroups;
    }

    @JacksonXmlProperty(isAttribute=true, localName="traffic_channel_pool_size")
    public int getTrafficChannelPoolSize() {
        return this.mTrafficChannelPoolSize;
    }

    public void setTrafficChannelPoolSize(int size) {
        this.mTrafficChannelPoolSize = size;
    }

    @Override
    @JsonIgnore
    public ChannelSpecification getChannelSpecification() {
        return new ChannelSpecification(50000.0, 12500, 6500.0, 7200.0);
    }

    @JacksonXmlProperty(isAttribute=false, localName="timeslot")
    public List<TimeslotFrequency> getTimeslotMap() {
        return this.mTimeslotMap;
    }

    public void setTimeslotMap(List<TimeslotFrequency> timeslots) {
        this.mTimeslotMap = timeslots;
    }

    @JsonIgnore
    public void addTimeslotFrequency(TimeslotFrequency timeslotFrequency) {
        this.mTimeslotMap.add(timeslotFrequency);
    }
}

