/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr;

import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelConversionRequest;
import io.github.dsheirer.controller.channel.ChannelEvent;
import io.github.dsheirer.controller.channel.IChannelEventListener;
import io.github.dsheirer.controller.channel.IChannelEventProvider;
import io.github.dsheirer.controller.channel.event.ChannelStartProcessingRequest;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.MessageHistoryPreloadData;
import io.github.dsheirer.message.MessageHistoryRequest;
import io.github.dsheirer.message.MessageHistoryResponse;
import io.github.dsheirer.module.decode.config.DecodeConfiguration;
import io.github.dsheirer.module.decode.dmr.DMRNetworkConfigurationMonitor;
import io.github.dsheirer.module.decode.dmr.DMRNetworkConfigurationPreloadData;
import io.github.dsheirer.module.decode.dmr.DecodeConfigDMR;
import io.github.dsheirer.module.decode.dmr.channel.DMRChannel;
import io.github.dsheirer.module.decode.dmr.event.DMRChannelGrantEvent;
import io.github.dsheirer.module.decode.dmr.identifier.DMRRadio;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.Opcode;
import io.github.dsheirer.module.decode.event.DecodeEvent;
import io.github.dsheirer.module.decode.event.DecodeEventHistory;
import io.github.dsheirer.module.decode.event.DecodeEventHistoryPreloadData;
import io.github.dsheirer.module.decode.event.DecodeEventHistoryRequest;
import io.github.dsheirer.module.decode.event.DecodeEventHistoryResponse;
import io.github.dsheirer.module.decode.event.DecodeEventType;
import io.github.dsheirer.module.decode.event.IDecodeEvent;
import io.github.dsheirer.module.decode.event.IDecodeEventProvider;
import io.github.dsheirer.module.decode.traffic.TrafficChannelManager;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.SourceType;
import io.github.dsheirer.source.config.SourceConfigTuner;
import io.github.dsheirer.source.config.SourceConfigTunerMultipleFrequency;
import io.github.dsheirer.source.tuner.channel.rotation.DisableChannelRotationMonitorRequest;
import io.github.dsheirer.source.tuner.channel.rotation.FrequencyLockChangeRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMRTrafficChannelManager
extends TrafficChannelManager
implements IDecodeEventProvider,
IChannelEventListener,
IChannelEventProvider {
    private static final Logger mLog = LoggerFactory.getLogger(DMRTrafficChannelManager.class);
    public static final String CHANNEL_START_REJECTED = " REJECTED - NO TUNER";
    public static final String DATA_CALL_IGNORED = "DATA CALL IGNORED";
    public static final String IGNORED = " - Ignored";
    public static final String MAX_TRAFFIC_CHANNELS_EXCEEDED = "MAX TRAFFIC CHANNELS EXCEEDED";
    public static final String NO_FREQUENCY = "NO FREQUENCY - CHECK LSN CHANNEL MAP";
    public static final long EVENT_TIME_STALE_THRESHOLD = 5000L;
    private Queue<Channel> mAvailableTrafficChannelQueue = new ConcurrentLinkedQueue<Channel>();
    private List<Channel> mManagedTrafficChannels;
    private Map<Long, Channel> mAllocatedTrafficChannelFrequencyMap = new ConcurrentHashMap<Long, Channel>();
    private Map<DMRChannel, DMRChannelGrantEvent> mChannelGrantEventMap = new ConcurrentHashMap<DMRChannel, DMRChannelGrantEvent>();
    private Listener<ChannelEvent> mChannelEventListener;
    private Listener<IDecodeEvent> mDecodeEventListener;
    private TrafficChannelTeardownMonitor mTrafficChannelTeardownMonitor = new TrafficChannelTeardownMonitor();
    private Channel mParentChannel;
    private DecodeEventHistory mTransientDecodeEventHistory;
    private List<IMessage> mTransientMessageHistory;
    private boolean mIgnoreDataCalls;
    private long mCurrentControlFrequency;

    public DMRTrafficChannelManager(Channel parentChannel) {
        this.mParentChannel = parentChannel;
        if (parentChannel.getDecodeConfiguration() instanceof DecodeConfigDMR) {
            this.mIgnoreDataCalls = ((DecodeConfigDMR)parentChannel.getDecodeConfiguration()).getIgnoreDataCalls();
        }
        this.createTrafficChannels();
    }

    public void setCurrentControlFrequency(long currentControlFrequency) {
        this.mCurrentControlFrequency = currentControlFrequency;
    }

    private void createTrafficChannels() {
        if (this.mManagedTrafficChannels == null) {
            DecodeConfigDMR decodeConfig;
            int maxTrafficChannels;
            DecodeConfiguration decodeConfiguration = this.mParentChannel.getDecodeConfiguration();
            ArrayList<Channel> trafficChannelList = new ArrayList<Channel>();
            if (decodeConfiguration instanceof DecodeConfigDMR && (maxTrafficChannels = (decodeConfig = (DecodeConfigDMR)decodeConfiguration).getTrafficChannelPoolSize()) > 0) {
                for (int x = 0; x < maxTrafficChannels; ++x) {
                    Channel trafficChannel = new Channel("T-" + this.mParentChannel.getName(), Channel.ChannelType.TRAFFIC);
                    trafficChannel.setAliasListName(this.mParentChannel.getAliasListName());
                    trafficChannel.setSystem(this.mParentChannel.getSystem());
                    trafficChannel.setSite(this.mParentChannel.getSite());
                    trafficChannel.setDecodeConfiguration(decodeConfig);
                    trafficChannel.setEventLogConfiguration(this.mParentChannel.getEventLogConfiguration());
                    trafficChannel.setRecordConfiguration(this.mParentChannel.getRecordConfiguration());
                    trafficChannelList.add(trafficChannel);
                }
            }
            this.mAvailableTrafficChannelQueue.addAll(trafficChannelList);
            this.mManagedTrafficChannels = Collections.unmodifiableList(trafficChannelList);
        }
    }

    public void convertToTrafficChannel(Channel channel, long currentFrequency, IChannelDescriptor restChannel, DMRNetworkConfigurationMonitor networkConfigurationMonitor) {
        if (restChannel.getDownlinkFrequency() > 0L && !this.mAllocatedTrafficChannelFrequencyMap.containsKey(restChannel.getDownlinkFrequency()) && channel.getSourceConfiguration().getSourceType() == SourceType.TUNER_MULTIPLE_FREQUENCIES) {
            Channel trafficChannel;
            SourceConfigTunerMultipleFrequency originalSourceConfig = (SourceConfigTunerMultipleFrequency)channel.getSourceConfiguration();
            if (!originalSourceConfig.getFrequencies().contains(restChannel.getDownlinkFrequency())) {
                originalSourceConfig.addFrequency(restChannel.getDownlinkFrequency());
            }
            if ((trafficChannel = this.mAvailableTrafficChannelQueue.poll()) != null && restChannel.getDownlinkFrequency() > 0L) {
                this.getInterModuleEventBus().post((Object)new DisableChannelRotationMonitorRequest());
                SourceConfigTuner trafficSourceConfig = new SourceConfigTuner();
                trafficSourceConfig.setFrequency(currentFrequency);
                trafficChannel.setSourceConfiguration(trafficSourceConfig);
                this.getInterModuleEventBus().post((Object)new DecodeEventHistoryRequest());
                this.getInterModuleEventBus().post((Object)new MessageHistoryRequest());
                this.getInterModuleEventBus().post((Object)new ChannelConversionRequest(channel, trafficChannel));
                this.mAllocatedTrafficChannelFrequencyMap.put(currentFrequency, trafficChannel);
                originalSourceConfig.setPreferredFrequency(restChannel.getDownlinkFrequency());
                ChannelStartProcessingRequest request = new ChannelStartProcessingRequest(channel, this);
                request.setPersistentAttempt(true);
                request.setChildDecodeEventHistory(this.mTransientDecodeEventHistory);
                if (this.mTransientDecodeEventHistory != null) {
                    DecodeEventHistoryPreloadData eventHistory = new DecodeEventHistoryPreloadData(this.mTransientDecodeEventHistory.getItems());
                    request.addPreloadDataContent(eventHistory);
                    this.mTransientDecodeEventHistory = null;
                }
                if (this.mTransientMessageHistory != null) {
                    MessageHistoryPreloadData messageHistory = new MessageHistoryPreloadData(this.mTransientMessageHistory);
                    request.addPreloadDataContent(messageHistory);
                    this.mTransientMessageHistory = null;
                }
                if (networkConfigurationMonitor != null) {
                    request.addPreloadDataContent(new DMRNetworkConfigurationPreloadData(networkConfigurationMonitor));
                }
                this.getInterModuleEventBus().post((Object)request);
            }
        }
    }

    @Subscribe
    public void process(DecodeEventHistoryResponse response) {
        this.mTransientDecodeEventHistory = response.getDecodeEventHistory();
    }

    @Subscribe
    public void process(MessageHistoryResponse response) {
        this.mTransientMessageHistory = response.getMessages();
    }

    public void broadcast(DecodeEvent decodeEvent) {
        if (this.mDecodeEventListener != null) {
            this.mDecodeEventListener.receive(decodeEvent);
        }
    }

    public void processEndChannelGrant() {
    }

    public void processChannelGrant(DMRChannel channel, IdentifierCollection identifierCollection, Opcode opcode, long timestamp, boolean encrypted) {
        DMRChannelGrantEvent event = this.mChannelGrantEventMap.get(channel);
        DecodeEventType decodeEventType = this.getEventType(opcode, identifierCollection, encrypted);
        if (this.isStale(event, timestamp, identifierCollection)) {
            event = DMRChannelGrantEvent.channelGrantBuilder(decodeEventType, timestamp).channel(channel).details("CHANNEL GRANT" + (encrypted ? " ENCRYPTED" : "")).identifiers(identifierCollection).build();
            this.mChannelGrantEventMap.put(channel, event);
        } else {
            Identifier currentFrom;
            Identifier from = this.getIdentifier(identifierCollection, Role.FROM);
            if (from != null && (currentFrom = this.getIdentifier(event.getIdentifierCollection(), Role.FROM)) != null && !Objects.equals(from, currentFrom)) {
                event.end(timestamp);
                event = DMRChannelGrantEvent.channelGrantBuilder(decodeEventType, timestamp).channel(channel).details("CONTINUE - CHANNEL GRANT" + (encrypted ? " ENCRYPTED" : "")).identifiers(identifierCollection).build();
                this.mChannelGrantEventMap.put(channel, event);
                this.broadcast(event);
            }
            event.update(timestamp);
        }
        this.broadcast(event);
        long frequency = channel.getDownlinkFrequency();
        if (frequency == 0L) {
            if (event.getDetails() == null) {
                event.setDetails(NO_FREQUENCY);
            } else if (!event.getDetails().endsWith(NO_FREQUENCY)) {
                event.setDetails(event.getDetails() + " - NO FREQUENCY - CHECK LSN CHANNEL MAP");
            }
            return;
        }
        if (frequency != this.mCurrentControlFrequency && !this.mAllocatedTrafficChannelFrequencyMap.containsKey(frequency)) {
            if (this.mIgnoreDataCalls && opcode.isDataChannelGrantOpcode()) {
                if (event.getDetails() == null) {
                    event.setDetails(DATA_CALL_IGNORED);
                } else if (!event.getDetails().endsWith(DATA_CALL_IGNORED)) {
                    event.setDetails(event.getDetails() + " - DATA CALL IGNORED");
                }
                this.broadcast(event);
                return;
            }
            Channel trafficChannel = this.mAvailableTrafficChannelQueue.poll();
            if (trafficChannel != null) {
                SourceConfigTuner sourceConfig = new SourceConfigTuner();
                sourceConfig.setFrequency(frequency);
                trafficChannel.setSourceConfiguration(sourceConfig);
                this.mAllocatedTrafficChannelFrequencyMap.put(frequency, trafficChannel);
                this.getInterModuleEventBus().post((Object)new ChannelStartProcessingRequest(trafficChannel, channel, identifierCollection));
            } else if (event.getDetails() == null) {
                event.setDetails(MAX_TRAFFIC_CHANNELS_EXCEEDED);
            } else if (!event.getDetails().endsWith(MAX_TRAFFIC_CHANNELS_EXCEEDED)) {
                event.setDetails(event.getDetails() + " - MAX TRAFFIC CHANNELS EXCEEDED");
            }
        }
    }

    private DecodeEventType getEventType(Opcode opcode, IdentifierCollection identifierCollection, boolean encrypted) {
        DecodeEventType type = null;
        switch (opcode) {
            case STANDARD_TALKGROUP_VOICE_CHANNEL_GRANT: 
            case STANDARD_BROADCAST_TALKGROUP_VOICE_CHANNEL_GRANT: {
                type = encrypted ? DecodeEventType.CALL_GROUP_ENCRYPTED : DecodeEventType.CALL_GROUP;
                break;
            }
            case MOTOROLA_CONPLUS_VOICE_CHANNEL_USER: {
                Identifier to = identifierCollection.getToIdentifier();
                if (to instanceof DMRRadio) {
                    type = encrypted ? DecodeEventType.CALL_UNIT_TO_UNIT_ENCRYPTED : DecodeEventType.CALL_UNIT_TO_UNIT;
                    break;
                }
                type = encrypted ? DecodeEventType.CALL_GROUP_ENCRYPTED : DecodeEventType.CALL_GROUP;
                break;
            }
            case STANDARD_PRIVATE_VOICE_CHANNEL_GRANT: 
            case STANDARD_DUPLEX_PRIVATE_VOICE_CHANNEL_GRANT: {
                type = encrypted ? DecodeEventType.CALL_UNIT_TO_UNIT_ENCRYPTED : DecodeEventType.CALL_UNIT_TO_UNIT;
                break;
            }
            case STANDARD_PRIVATE_DATA_CHANNEL_GRANT_SINGLE_ITEM: 
            case STANDARD_TALKGROUP_DATA_CHANNEL_GRANT_SINGLE_ITEM: 
            case STANDARD_DUPLEX_PRIVATE_DATA_CHANNEL_GRANT: 
            case STANDARD_PRIVATE_DATA_CHANNEL_GRANT_MULTI_ITEM: 
            case STANDARD_TALKGROUP_DATA_CHANNEL_GRANT_MULTI_ITEM: 
            case MOTOROLA_CONPLUS_DATA_CHANNEL_GRANT: {
                DecodeEventType decodeEventType = type = encrypted ? DecodeEventType.DATA_CALL_ENCRYPTED : DecodeEventType.DATA_CALL;
            }
        }
        if (type == null) {
            mLog.debug("Unrecognized opcode for determining decode event type: " + opcode.name());
            type = DecodeEventType.CALL;
        }
        return type;
    }

    @Override
    public Listener<ChannelEvent> getChannelEventListener() {
        return this.mTrafficChannelTeardownMonitor;
    }

    private void broadcast(ChannelEvent channelEvent) {
        if (this.mChannelEventListener != null) {
            this.mChannelEventListener.receive(channelEvent);
        }
    }

    @Override
    public void setChannelEventListener(Listener<ChannelEvent> listener) {
        this.mChannelEventListener = listener;
    }

    @Override
    public void removeChannelEventListener() {
        this.mChannelEventListener = null;
    }

    private boolean isSameCall(IdentifierCollection collection1, IdentifierCollection collection2) {
        Identifier toIdentifier1 = this.getIdentifier(collection1, Role.TO);
        Identifier toIdentifier2 = this.getIdentifier(collection2, Role.TO);
        return Objects.equals(toIdentifier1, toIdentifier2);
    }

    private boolean isStale(DecodeEvent event, long timestamp, IdentifierCollection currentIdentifiers) {
        if (event == null) {
            return true;
        }
        if (timestamp - event.getTimeEnd() > 5000L) {
            return true;
        }
        return !this.isSameCall(event.getIdentifierCollection(), currentIdentifiers);
    }

    private Identifier getIdentifier(IdentifierCollection collection, Role role) {
        List<Identifier> identifiers = collection.getIdentifiers(role);
        if (identifiers.size() >= 1) {
            return identifiers.get(0);
        }
        return null;
    }

    @Override
    public void addDecodeEventListener(Listener<IDecodeEvent> listener) {
        this.mDecodeEventListener = listener;
    }

    @Override
    public void removeDecodeEventListener(Listener<IDecodeEvent> listener) {
        this.mDecodeEventListener = null;
    }

    @Override
    public void reset() {
    }

    @Override
    public void start() {
        for (Long frequency : this.mAllocatedTrafficChannelFrequencyMap.keySet()) {
            this.getInterModuleEventBus().post((Object)FrequencyLockChangeRequest.lock(frequency));
        }
    }

    @Override
    public void stop() {
        this.mAvailableTrafficChannelQueue.clear();
        ArrayList<Channel> channels = new ArrayList<Channel>(this.mAllocatedTrafficChannelFrequencyMap.values());
        for (Channel channel : channels) {
            this.broadcast(new ChannelEvent(channel, ChannelEvent.Event.REQUEST_DISABLE));
        }
    }

    public class TrafficChannelTeardownMonitor
    implements Listener<ChannelEvent> {
        private void removeCallEvents(long frequency) {
            ArrayList<DMRChannel> channelsToRemove = new ArrayList<DMRChannel>();
            for (Map.Entry<DMRChannel, DMRChannelGrantEvent> entry : DMRTrafficChannelManager.this.mChannelGrantEventMap.entrySet()) {
                if (entry.getKey().getDownlinkFrequency() != frequency) continue;
                channelsToRemove.add(entry.getKey());
            }
            for (DMRChannel channel : channelsToRemove) {
                DMRTrafficChannelManager.this.mChannelGrantEventMap.remove(channel);
            }
        }

        private void updateCallEventDetails(long frequency, String detailFragment) {
            ArrayList<DMRChannel> channelsToUpdate = new ArrayList<DMRChannel>();
            for (Map.Entry<DMRChannel, DMRChannelGrantEvent> entry : DMRTrafficChannelManager.this.mChannelGrantEventMap.entrySet()) {
                if (entry.getValue().getChannelDescriptor().getDownlinkFrequency() != frequency) continue;
                channelsToUpdate.add(entry.getKey());
            }
            for (DMRChannel channel : channelsToUpdate) {
                DMRChannelGrantEvent event = DMRTrafficChannelManager.this.mChannelGrantEventMap.get(channel);
                if (event == null) continue;
                if (event.getDetails() == null) {
                    event.setDetails(detailFragment);
                } else if (!event.getDetails().endsWith(detailFragment)) {
                    event.setDetails(event.getDetails() + detailFragment);
                }
                DMRTrafficChannelManager.this.broadcast(event);
            }
        }

        @Override
        public synchronized void receive(ChannelEvent channelEvent) {
            Channel channel = channelEvent.getChannel();
            if (channel.isTrafficChannel()) {
                switch (channelEvent.getEvent()) {
                    case NOTIFICATION_PROCESSING_STOP: {
                        long frequencyToRemove = 0L;
                        for (Map.Entry<Long, Channel> entry : DMRTrafficChannelManager.this.mAllocatedTrafficChannelFrequencyMap.entrySet()) {
                            if (channel != entry.getValue() || entry.getKey() == null) continue;
                            frequencyToRemove = entry.getKey();
                            this.removeCallEvents(entry.getKey());
                            break;
                        }
                        if (frequencyToRemove > 0L) {
                            DMRTrafficChannelManager.this.mAllocatedTrafficChannelFrequencyMap.remove(frequencyToRemove);
                            DMRTrafficChannelManager.this.getInterModuleEventBus().post((Object)FrequencyLockChangeRequest.unlock(frequencyToRemove));
                        }
                        if (DMRTrafficChannelManager.this.mAvailableTrafficChannelQueue.contains(channel)) break;
                        DMRTrafficChannelManager.this.mAvailableTrafficChannelQueue.add(channel);
                        break;
                    }
                    case NOTIFICATION_PROCESSING_START_REJECTED: {
                        long frequencyToUpdate = 0L;
                        for (Map.Entry<Long, Channel> entry : DMRTrafficChannelManager.this.mAllocatedTrafficChannelFrequencyMap.entrySet()) {
                            if (channel != entry.getValue() || entry.getKey() == null) continue;
                            frequencyToUpdate = entry.getKey();
                            this.updateCallEventDetails(entry.getKey(), DMRTrafficChannelManager.CHANNEL_START_REJECTED);
                            break;
                        }
                        if (frequencyToUpdate > 0L) {
                            DMRTrafficChannelManager.this.mAllocatedTrafficChannelFrequencyMap.remove(frequencyToUpdate);
                            DMRTrafficChannelManager.this.getInterModuleEventBus().post((Object)FrequencyLockChangeRequest.unlock(frequencyToUpdate));
                        }
                        if (DMRTrafficChannelManager.this.mAvailableTrafficChannelQueue.contains(channel)) break;
                        DMRTrafficChannelManager.this.mAvailableTrafficChannelQueue.add(channel);
                    }
                }
            }
        }
    }
}

