/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr;

import java.util.EnumSet;

public enum DMRSyncPattern {
    BASE_STATION_DATA(246245464858461L, 205264740399867L, 76210236310788L, 35229511852194L, "BS DATA"),
    BASE_STATION_VOICE(129054504089079L, 263860220784558L, 17614755926097L, 152420472621576L, "BS VOICE A"),
    MOBILE_STATION_DATA(235123547035479L, 210825699311358L, 70649277399297L, 46351429675176L, "MS DATA"),
    MOBILE_STATION_VOICE(140176421912061L, 258299261873067L, 23175714837588L, 141298554798594L, "MS VOICE A"),
    DIRECT_MODE_DATA_TIMESLOT_1(272669586881877L, 192052679388159L, 89422297322496L, 8805389828778L, "MS DATA - DUAL CAPACITY DIRECT MODE"),
    DIRECT_MODE_DATA_TIMESLOT_2(236762209187829L, 210006368235183L, 71468608475472L, 44712767522826L, "MS DATA - DUAL CAPACITY DIRECT MODE"),
    DIRECT_MODE_VOICE_TIMESLOT_1(102630382065663L, 277072281796266L, 4402694914389L, 178844594644992L, "MS VOICE A - DUAL CAPACITY DIRECT MODE"),
    DIRECT_MODE_VOICE_TIMESLOT_2(138537759759711L, 259118592949242L, 22356383761413L, 142937216950944L, "MS VOICE A - DUAL CAPACITY DIRECT MODE"),
    MOBILE_STATION_REVERSE_CHANNEL(131758313831799L, 262508315913198L, 18966660797457L, 149716662878856L, "MS RVRS"),
    RESERVED(243541655115741L, 206616645271227L, 74858331439428L, 37933321594914L, "RESERVED"),
    BS_VOICE_FRAME_B("BS VOICE B"),
    BS_VOICE_FRAME_C("BS VOICE C"),
    BS_VOICE_FRAME_D("BS VOICE D"),
    BS_VOICE_FRAME_E("BS VOICE E"),
    BS_VOICE_FRAME_F("BS VOICE F"),
    MS_VOICE_FRAME_B("MS VOICE B"),
    MS_VOICE_FRAME_C("MS VOICE C"),
    MS_VOICE_FRAME_D("MS VOICE D"),
    MS_VOICE_FRAME_E("MS VOICE E"),
    MS_VOICE_FRAME_F("MS VOICE F"),
    UNKNOWN("UNKNOWN");

    private long mPattern;
    private long mPlus90Pattern;
    private long mMinus90Pattern;
    private long mInvertedPattern;
    private String mLabel;
    public static final EnumSet<DMRSyncPattern> SYNC_PATTERNS;
    private static final EnumSet<DMRSyncPattern> CACH_PATTERNS;
    private static final EnumSet<DMRSyncPattern> DIRECT_MODE_TS1_PATTERNS;
    private static final EnumSet<DMRSyncPattern> DIRECT_MODE_TS2_PATTERNS;
    private static final EnumSet<DMRSyncPattern> MOBILE_STATION_PATTERNS;

    private DMRSyncPattern(long pattern, long plus90Pattern, long minus90Pattern, long invertedPattern, String label) {
        this.mPattern = pattern;
        this.mPlus90Pattern = plus90Pattern;
        this.mMinus90Pattern = minus90Pattern;
        this.mInvertedPattern = invertedPattern;
        this.mLabel = label;
    }

    private DMRSyncPattern(String label) {
        this.mLabel = label;
    }

    public long getPattern() {
        return this.mPattern;
    }

    public long getPlus90Pattern() {
        return this.mPlus90Pattern;
    }

    public long getMinus90Pattern() {
        return this.mMinus90Pattern;
    }

    public long getInvertedPattern() {
        return this.mInvertedPattern;
    }

    public boolean hasCACH() {
        return CACH_PATTERNS.contains((Object)this);
    }

    public boolean isDirectMode() {
        return this.isDirectModeTS1() || this.isDirectModeTS2();
    }

    public boolean isDirectModeTS1() {
        return DIRECT_MODE_TS1_PATTERNS.contains((Object)this);
    }

    public boolean isDirectModeTS2() {
        return DIRECT_MODE_TS2_PATTERNS.contains((Object)this);
    }

    public boolean isMobileStationSyncPattern() {
        return MOBILE_STATION_PATTERNS.contains((Object)this);
    }

    public boolean isMobileSyncPattern() {
        return this.isMobileStationSyncPattern() || this.isDirectMode();
    }

    public String toString() {
        return this.mLabel;
    }

    static {
        SYNC_PATTERNS = EnumSet.of(BASE_STATION_DATA, new DMRSyncPattern[]{BASE_STATION_VOICE, MOBILE_STATION_DATA, MOBILE_STATION_VOICE, DIRECT_MODE_DATA_TIMESLOT_1, DIRECT_MODE_DATA_TIMESLOT_2, DIRECT_MODE_VOICE_TIMESLOT_1, DIRECT_MODE_VOICE_TIMESLOT_2, MOBILE_STATION_REVERSE_CHANNEL});
        CACH_PATTERNS = EnumSet.of(BASE_STATION_DATA, new DMRSyncPattern[]{BASE_STATION_VOICE, BS_VOICE_FRAME_B, BS_VOICE_FRAME_C, BS_VOICE_FRAME_D, BS_VOICE_FRAME_E, BS_VOICE_FRAME_F});
        DIRECT_MODE_TS1_PATTERNS = EnumSet.of(DIRECT_MODE_VOICE_TIMESLOT_1, DIRECT_MODE_DATA_TIMESLOT_1);
        DIRECT_MODE_TS2_PATTERNS = EnumSet.of(DIRECT_MODE_VOICE_TIMESLOT_2, DIRECT_MODE_DATA_TIMESLOT_2);
        MOBILE_STATION_PATTERNS = EnumSet.of(MOBILE_STATION_DATA, new DMRSyncPattern[]{MOBILE_STATION_VOICE, MS_VOICE_FRAME_B, MS_VOICE_FRAME_C, MS_VOICE_FRAME_D, MS_VOICE_FRAME_E, MS_VOICE_FRAME_F});
    }
}

